
/* *** CREATED BY NAPA V4.40c [Win64] ***** Thu Jul 04 10:04:45 2024 ********************************************************** */

/* *** Ad Hoc Cycle-Based ANSI-C Simulator Compiled for 'Anonymous User'                                                    *** */

/* *** Author and support:  Yves Leduc                                                                                      *** */
/* *** Email:  yves.leduc.be@gmail.com                                                                                      *** */

/* ***                                                                                                                      *** */
/* ***                                                                                                                      *** */
/* *** Transfer function of a symmetrical FIR                                                                               *** */
/* ***                                                                                                                      *** */
/* ***                                                                                                                      *** */

/* This ANSI-C [C17] code has been produced by the NAPA compiler from these 3 netlist files:                                    */

/*  (main)  -> "fir.tmp"                                                                                                        */
/*          -> "D:/Simulate/NapaDos/Net/Noise/rclock.net"                                                                       */
/*          -> "fltr_0.gen"                                                                                                     */

/* These libraries have been REGISTERED by the user in the NAPA compiler line command:                                          */

/*          -> Generic headers    :    "D:/Simulate/NapaDos/Hdr"                                                                */
/*          -> Generic cells      :    "D:/Simulate/NapaDos/Net"                                                                */
/*          -> Generic generators :    "D:/Simulate/NapaDos/Gen"                                                                */

/* According to the user's demand, the ping function is implemented and activated.                                              */

/* This simulator is built for Windows OS, where the file names are not case-sensitive.                                         */

/* (char) coded with              :    1 byte   (C_TYPE)                                                                        */
/* (short int) coded with         :    2 bytes                                                                                  */
/* (int) coded with               :    4 bytes                                                                                  */
/* (long int) coded with          :    4 bytes  (P_TYPE)                                                                        */
/* (long long int) coded with     :    8 bytes  (I_TYPE)                                                                        */
/* (float) coded with             :    4 bytes  (L_PREC)                                                                        */
/* (double float) coded with      :    8 bytes  (R_TYPE)                                                                        */
/* (long double float) coded with :   16 bytes  (H_PREC)                                                                        */
/* (size_t) coded with            :    8 bytes                                                                                  */
/* (void*) coded with             :    8 bytes                                                                                  */

/* Resolution of a (double float) :   15 digits                                                                                 */

/* Number of user's nodes         :   53                                                                                        */
/* Number of user's variables     :   12                                                                                        */
/* Number of user's directives    :    1                                                                                        */
/* Number of analysis tools       :    1                                                                                        */
/* Number of user's declarations  :    2                                                                                        */
/* Number of cell instantiations  :    2                                                                                        */

/* Simulation rate                :    1.00000 MHz                                                                              */
/* Sampling frequency             :    1.00000 MHz                                                                              */


/* FYI, the internal pseudo-random generator uses a seed chosen randomly at the SIMULATION time.                                */
/* Use the RANDOM_SEED value produced during this simulation to restart a new simulation in the same conditions.                */

/* Please feel free to report bugs or suggestions to 'yves.leduc.be@gmail.com'                                                  */


/* *** INCLUDE ANSI-C [C17] STANDARD HEADER FILES ***************************************************************************** */

#include <ctype.h>
#include <limits.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdbool.h>
#ifdef __GNUC__
  #include <unistd.h>
#endif


/* *** MACRO CONSTANTS AND VARIABLES AVAILABLE TO USER ************************************************************************ */

#define  NAPA_WAYPOINT         ( napa_waypoint )

#define  PLATFORM              "Win64"
#define  NAPA_VERSION          "V4.40c for " PLATFORM

#define  USER                  "Anonymous User"                                                   /* from NAPA line command     */
#define  CREATED               "Thu Jul 04 10:04:45 2024 by " USER
#define  NAPA_JOB_ID           "AU247381885"                                                      /* unique tag                 */

#define  NAPA_CWD              napa_cwd                                                           /* current working directory  */

#define  ORIGIN                "fir"
#define  SOURCE                "fir.tmp"                                                          /* NAPA main netlist file     */
#define  CODE                  "fir.c"                                                            /* this C file                */

#define  HEADERS_LIB           "D:/Simulate/NapaDos/Hdr"
#define  CELLS_LIB             "D:/Simulate/NapaDos/Net"
#define  GENERATORS_LIB        "D:/Simulate/NapaDos/Gen"

#define  TITLE                 napa_title
#define  SHORT_TITLE           napa_title

#define  TERMINATE             ( 1<=TOOL_INDEX )

#define  NUM_OF_TIME_OUTPUTS   0L
#define  NUM_OF_SEGMENTS       1L

#define  SEGMENT               0L

#define  RANDOM_SEED           860040142LL                                                        /* unique random seed         */
#define  ANTITHETIC            false

#define  TIME                  ( (R_TYPE) napa_abs_time )
#define  REF_TIME              ( (R_TYPE) napa_abs_time )
#define  ABS_TIME              ( (R_TYPE) napa_abs_time )
#define  REL_TIME              ( (R_TYPE) napa_rel_time )

#define  LOOP_INDEX            ( (I_TYPE) napa_abs_loop )
#define  ABS_LOOP_INDEX        ( (I_TYPE) napa_abs_loop )
#define  REL_LOOP_INDEX        ( (I_TYPE) napa_rel_loop )

#define  SIM_RATE              1.000000000000000e+06L
#define  FS                    1.000000000000000e+06L
#define  FSL                   1.000000000000000e+06
#define  STL                   0LL
#define  PERIODIC              true

#define  ERROR_FLAG            ( napa_error_flag )

#define  WALL_CLOCK            ( ((R_TYPE) (clock()-napa_wall_clock)) / ((R_TYPE) CLOCKS_PER_SEC) )

#define  TOOL_INDEX            ( napa_tool_index )
#define  PACKET                ( napa_packet )
#define  MAILBOX               1                                                                  /* one box per tool instance  */
#define  SYNCHRONIZE           YES

#define  I_FORMAT              " % 11lld"                                                         /* output format by default   */
#define  X_FORMAT              " %#018llX"                                                        /* output format by default   */
#define  R_FORMAT              " % .12e"                                                          /* output format by default   */
#define  S_FORMAT              " %12s"                                                            /* output format by default   */

#define  SEPARATOR             "\n"

#define  ANALOG_INI            0.0
#define  DIGITAL_INI           0LL

#define  TRUE                  true
#define  FALSE                 false
#define  YES                   true
#define  NO                    false

#define  LITTLE_ENDIAN         1
#define  BIG_ENDIAN            0
#define  CPU_ARCHITECTURE      LITTLE_ENDIAN                                                      /* targetted architecture     */


/* *** MACRO FUNCTIONS MADE AVAILABLE TO USER AND USER'S FUNCTIONS ************************************************************ */

#define  MIN(x,y)              (((x)<(y))?(x):(y))                                 /* regardless of the type                    */
#define  MAX(x,y)              (((x)>(y))?(x):(y))                                 /* regardless of the type                    */
#define  CLIP(x,l,h)           (((x)<(l))?(l):(((x)>(h))?(h):(x)))                 /* regardless of the type                    */

#define  ABS(x)                ((0.0<(x))?(x):-(x))                                /* regardless of the type                    */
#define  SIGN(x)               ((EPSILON<(x))-(-EPSILON>(x)))                      /* returns -1, 0 or 1                        */

#define  ISSMALL(x)            (EPSILON>=ABS(x))                                   /* to be used in replacement of ( 0.0 == x ) */
#define  ISNOTSMALL(x)         (EPSILON< ABS(x))                                   /* to be used in replacement of ( 0.0 != x ) */

#define  ISINTEGER(x)          (((I_TYPE)(x))==(x))                                /* check the value, regardless of the type   */
#define  ISNAN(x)              ((x)!=(x))                                          /* check if the value is NaN                 */

#define  ISEVEN(x)             (0LL==(D2I(x)%2LL))                                 /* check the value, regardless of the type   */
#define  ISODD(x)              (0LL!=(D2I(x)%2LL))                                 /* check the value, regardless of the type   */

#define  ISEQUAL(x,y)          (ABS((x)-(y))<=(EPSILON*(ABS(x)+ABS(y))))           /* to be used in replacement of ( x == y )   */
#define  ISNOTEQUAL(x,y)       (ABS((x)-(y))> (EPSILON*(ABS(x)+ABS(y))))           /* to be used in replacement of ( x != y )   */

#define  ISINSIDE(x,l,h)       (((x)>=(l))&&((x)<=(h)))                            /* inside the interval [l,h]                 */
#define  ISOUTSIDE(x,l,h)      (((x)< (l))||((x)> (h)))                            /* outside the interval ]l,h[                */
#define  ISTIME(t)             (((FSL*((t)-TIME))<0.5)&&((FSL*(TIME-(t)))<=0.5))   /* time inside the local sampling interval   */

#define  MODULO(x,y)           ((x)-((y)*floor(((R_TYPE)(x))/((R_TYPE)(y)))))      /* regardless of the type                    */

#define  SIN(x)                ((R_TYPE)sinl((H_PREC)(x)))                         /* keep the best precision when x is large   */
#define  COS(x)                ((R_TYPE)cosl((H_PREC)(x)))                         /* keep the best precision when x is large   */
#define  SQR(x)                ((x)*(x))                                           /* regardless of the type                    */
#define  SQRT(x)               sqrt(MAX(0.0,(x)))                                  /* avoiding negative values                  */
#define  LOG(x)                log(MAX(EPSILON,(x)))                               /* avoiding values below or equal to zero    */
#define  POW(x,y)              pow(MAX(0.0,(x)),(y))                               /* avoiding negative values                  */
#define  ROOT(x,y)             POW((x),1.0/((R_TYPE)(y)))                          /* avoiding negative values                  */
#define  LOG10(x)              log10(MAX(EPSILON,(x)))                             /* avoiding values below or equal to zero    */
#define  POW10(y)              pow(10.0,(y))

#define  POWEROF2(n)           ((0LL<((I_TYPE)(n)))?(1LL<<((I_TYPE)(n))):1LL)      /* valid only for positive integers          */

#define  I2D(n)                ((R_TYPE)(n))                                       /* convert integer to real                   */
#define  D2I(x)                ((0.0<(x))?((I_TYPE)((x)+0.5)):((I_TYPE)((x)-0.5))) /* convert real to nearest integer           */

#define  DB2LIN(x,r)           ((r)*POW10(0.05*(x)))                               /* convert dB to linear                      */
#define  LIN2DB(x,r)           (20.0*LOG10(((R_TYPE)(x))/((R_TYPE)(r))))           /* convert linear to dB                      */
#define  DB2POW(x,r)           ((r)*POW10(0.10*(x)))                               /* convert dB to power                       */
#define  POW2DB(x,r)           (10.0*LOG10(((R_TYPE)(x))/((R_TYPE)(r))))           /* convert power to dB                       */
#define  RAD2DEG(x)            (57.2957795130823209*((R_TYPE)(x)))                 /* convert radian to degree                  */
#define  DEG2RAD(x)            (0.01745329251994329577*((R_TYPE)(x)))              /* convert degree to radian                  */

#define  B2A(b)                ((b)?"true":"false")                                /* convert boolean to string                 */
#define  LENGTH(s)             ((I_TYPE)strlen(s))                                 /* length of a string                        */

#define  LINDOMAIN(c,b,e)      ((b)+((c)*((e)-(b))))                                              /* linear rule of thumb       */
#define  LOGDOMAIN(c,b,e)      ((b)*POW10((c)*LOG10(((R_TYPE)(e))/((R_TYPE)(b)))))                /* logarithmic rule of thumb  */
#define  LINSWEEP(c,b,e,n)     LINDOMAIN((((R_TYPE)(c))/((R_TYPE)((n)-1L))),(b),(e))              /* linearly spaced            */
#define  LOGSWEEP(c,b,e,n)     LOGDOMAIN((((R_TYPE)(c))/((R_TYPE)((n)-1L))),(b),(e))              /* logarithmically spaced     */

#define  RAND_01()             (1.11022302462515666e-16* ((R_TYPE)(napa_rand()>>10))     )        /* number in interval [0,1]   */
#define  RAND_01_X()           (2.22044604925031332e-16*(((R_TYPE)(napa_rand()>>11))+0.5))        /* number in interval ]0,1[   */

#define  FSS(s)                1.000000000000000e+06                                              /* constant                   */
#define  STS(s)                0LL                                                                /* constant                   */
#define  PS(s)                 true                                                               /* constant                   */

#define  TIMER(n)              napa_timer(n)                                                      /* pause for n seconds        */

#define  PING(fun)                                                   \
  void napa_ping_ ## fun(void);                                      \
  void napa_ping_ ## fun(void) {                                     \
    (void) fprintf(stderr,       "NAPA Ping Information :     "  );  \
    (void) fprintf(stderr,       "function '%-19s", #fun "()' "  );  \
    (void) fprintf(stderr,       "from file \"%s\"\n", __FILE__  );  \
    return;                                                          \
  }
#define  PING_FAIL(fun)                                              \
  (void) fprintf(stderr,         "NAPA Ping Information :     "  );  \
  (void) fprintf(stderr,         "function '%-19s", #fun "()' "  );  \
  (void) fprintf(stderr,         "exists but cannot be located\n");


/* *** MACRO FUNCTIONS TO BE USED IN USER, TOOL AND POST FUNCTIONS ************************************************************ */

#define  IO_COMMAND_NAME(c)    (napa_IO_cmd[c])                                                   /* list defined below         */
#define  IO_MANAGER(c,f,n,s,t) napa_IO_manager(c,f,n,s,t)                                         /* function defined below     */

#define  ISOPTION(f,i,o)       (0.0<(*napa_check_for_option(f,i,o,1)))                            /* for user, tool, post       */
#define  ISNOTOPTION(f,i)      (ISOPTION(f,i,"_another_"))                                        /* for user, tool, post       */
#define  ISPARAMETER(f,i,o)    (((double*)NULL)!=napa_check_for_option(f,i,o,0))                  /* for user, tool, post       */
#define  GETPARMADDRESS(f,i,o) napa_check_for_option(f,i,o,0)                                     /* for user, tool, post       */


/* *** SUGGESTION:  USE THESE NAPA DIRECTIVES IN THE NAPA NETLIST TO CONFIGURE FURTHER THIS SIMULATION ************************ */

/*  directive TIME_OFFSET      <H_PREC Number>                                                                                  */
/*  directive JITTER           <H_PREC Formula>                                                                                 */
/*  directive EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR  <File Pathname>                                                          */
/*  directive NAPA_EXIT_STATUS                                                                                                  */

/*  debug     IO                                                                                                                */

/*  directive ALL_DEBUG                                                                                                         */
/*  directive VERBOSE                                                                                                           */

/*  [ The header files of the library may also be configured with specific directives, please consult related documentation ]   */


/* *** DECLARE NAPA TYPES ***************************************************************************************************** */

typedef   long long I_TYPE;
typedef      double R_TYPE;
typedef        char C_TYPE;
typedef        long P_TYPE;

typedef       float L_PREC;
typedef long double H_PREC;

#define _IO_LST_                  \
        _IO_( UNKNOWN           ) \
        _IO_( CLOSE             ) \
        _IO_( OPENREAD          ) \
        _IO_( OPENREAD_BINARY   ) \
        _IO_( OPENWRITE         ) \
        _IO_( OPENWRITE_BINARY  ) \
        _IO_( OPENAPPEND        ) \
        _IO_( OPENAPPEND_BINARY ) \
        _IO_( QUERY             ) \
        _IO_( REWIND            ) \
        _IO_( REWRITE           ) \
        _IO_( ALLOCATE          ) \
        _IO_( FREE              ) \
        _IO_( DELETE            ) \
        _IO_( RESET             ) \
        _IO_( DEBUG             )
#define _IO_(x)  x,
typedef enum  { _IO_LST_ } IO_COMMAND;                                             /* enumeration of the NAPA I/O commands      */

#undef  _IO_
#define _IO_(x) #x,
const   char* const napa_IO_cmd[16] = { _IO_LST_ };                                /* strings corresponding to the I/O commands */

#undef  _IO_
#undef  _IO_LST_

typedef struct {
  C_TYPE     name[512];
  C_TYPE   **s_ptr;
  C_TYPE   **n_ptr;
  I_TYPE   **i_ptr;
  R_TYPE   **d_ptr;
  C_TYPE   **c_ptr;
  int        nflag;
  int        pflag;
  long       length;
  long       nrow;
  long       ncol;
} DATA_RECORD;

typedef struct {
  FILE      *f_ptr;
  C_TYPE    *user;
  long       id;
  IO_COMMAND mode;
  int        iflag;
  int        oflag;
} IO_RECORD;

typedef struct {
  long      *store_i;                                                                             /* managed by user            */
  I_TYPE    *store_l;                                                                             /* managed by user            */
  R_TYPE    *store_d;                                                                             /* managed by user            */
  C_TYPE   **store_s;                                                                             /* managed by user            */
  I_TYPE     n;                                                                                   /* managed by user            */
  I_TYPE     i;                                                                                   /* message input              */
  I_TYPE     o;                                                                                   /* message output             */
  long       m;                                                                                   /* mailbox ID                 */
  long       s;                                                                                   /* segment ID                 */
  char       t[64];                                                                               /* tool name                  */
  char       u[2047];                                                                             /* node name                  */
} MAILBOX_RECORD;


/* *** DECLARE GLOBAL CONSTANTS *********************************************************************************************** */

const I_TYPE  START             =  1LL;
const I_TYPE  STOP              =  0LL;

const I_TYPE  yes               =  1LL;
const I_TYPE  no                =  0LL;

const R_TYPE _pi_               =  3.141592653589793;
const R_TYPE _pi2_              =  1.570796326794897;
const R_TYPE _pi4_              =  0.7853981633974483;
const R_TYPE _pi8_              =  0.3926990816987242;
const R_TYPE _2pi_              =  6.283185307179586;
const R_TYPE _e_                =  2.718281828459045;

const H_PREC _PI_               =  3.141592653589793239L;
const H_PREC _PI2_              =  1.570796326794896619L;
const H_PREC _PI4_              =  0.7853981633974483096L;
const H_PREC _PI8_              =  0.3926990816987241548L;
const H_PREC _2PI_              =  6.283185307179586477L;
const H_PREC _E_                =  2.718281828459045235L;

const R_TYPE  EPSILON           =  2.0e-15;                                                       /* used as 'small' number     */


/* *** DECLARE GLOBAL CONSTANTS *** (not to be used outside of this code, use corresponding macros defined above instead) ***** */

const int    napa_per[1]        =  { true };

const C_TYPE napa_title[39]     =  "Transfer function of a symmetrical FIR";


/* *** DECLARE GLOBAL VARIABLES *** (not to be used outside of this code, use corresponding macros defined above instead) ***** */

char       napa_cwd[128]        =  "Unknown";

int        napa_waypoint        = -1;


I_TYPE     napa_tool_index      =  0LL;

H_PREC     napa_abs_loop        =  0.0L;
H_PREC     napa_rel_loop        =  0.0L;

H_PREC     napa_abs_time        =  0.0L;
H_PREC     napa_ref_time        =  0.0L;
H_PREC     napa_rel_time        =  0.0L;

I_TYPE     napa_random_seed     =  0LL;

long       napa_IO_count        =  0L;
IO_RECORD  napa_IO_record[63];

I_TYPE     napa_packet          =  1LL;

clock_t    napa_wall_clock      =  0;

int        napa_output_flag     =  false;
int        napa_error_flag      =  false;

MAILBOX_RECORD *napa_msg        =  (MAILBOX_RECORD*) NULL;
MAILBOX_RECORD  napa_mailbox[MAILBOX];


/* *** DECLARE GLOBAL FUNCTION POINTERS *************************************************************************************** */

I_TYPE   (*napa_seed)(I_TYPE)   =  NULL;
I_TYPE   (*napa_rand)(void)     =  NULL;
I_TYPE   (*napa_root)(I_TYPE)   =  NULL;


/* *** NAPA FUNCTION PROTOTYPES *********************************************************************************************** */

void       napa_control_init(void);
void       napa_tool_setup(void);

void       napa_init(void);                                                      /* see "D:/Simulate/NapaDos/Hdr/napatool.hdr"  */
void       napa_close(void);                                                     /* see "D:/Simulate/NapaDos/Hdr/napatool.hdr"  */
void       napa_end(void);
void       napa_exit(int);

void       napa_timer(long);

void       napa_reset_variables(void);
void       napa_reset_nodes(void);

void       napa_check_directives(void);
double    *napa_check_for_option(char*, long, char*, int);

IO_COMMAND napa_IO_manager(IO_COMMAND, FILE**, char*, char*, char*);

I_TYPE     napa_rand_integer(I_TYPE);                                                             /*  basic random generator    */

I_TYPE     napa_default_seed(I_TYPE);                                                             /*  seed generator            */
I_TYPE     napa_default_root(I_TYPE);                                                             /*  seed randomizer           */
I_TYPE     napa_default_rand(void);                                                               /*  random generator          */

void       napa_ping(int);


/* *** USER'S FUNCTION COMPILATION DIRECTIVES ********************************************************************************* */

#define COMPILE_itool_tf   1                                                                      /*  1 instance  in netlist    */

#define COMPILE_rand_bernoulli


/* *** USER'S COMPILATION DIRECTIVES ****************************************************************************************** */

#define REPEAT           10


/* *** DECLARATIONS *********************************************************************************************************** */

/* (declare variables)                      */
I_TYPE  ivar_npts;
I_TYPE  ivar_fltr__h0;
I_TYPE  ivar_fltr__h1;
I_TYPE  ivar_fltr__h2;
I_TYPE  ivar_fltr__h3;
I_TYPE  ivar_fltr__h4;
I_TYPE  ivar_fltr__h5;
I_TYPE  ivar_fltr__h6;
I_TYPE  ivar_fltr__h7;
I_TYPE  ivar_fltr__h8;
I_TYPE  ivar_fltr__h9;
I_TYPE  ivar_fltr__h10;

/* (declare nodes)                          */
I_TYPE  inode_fltr__d20;
I_TYPE  inode_fltr__d19;
I_TYPE  inode_fltr__d18;
I_TYPE  inode_fltr__d17;
I_TYPE  inode_fltr__d16;
I_TYPE  inode_fltr__d15;
I_TYPE  inode_fltr__d14;
I_TYPE  inode_fltr__d13;
I_TYPE  inode_fltr__d12;
I_TYPE  inode_fltr__d11;
I_TYPE  inode_fltr__d10;
I_TYPE  inode_fltr__d9;
I_TYPE  inode_fltr__d8;
I_TYPE  inode_fltr__d7;
I_TYPE  inode_fltr__d6;
I_TYPE  inode_fltr__d5;
I_TYPE  inode_fltr__d4;
I_TYPE  inode_fltr__d3;
I_TYPE  inode_fltr__d2;
I_TYPE  inode_fltr__d1;
I_TYPE  inode_in;
I_TYPE  inode_fltr__s0;
I_TYPE  inode_fltr__s1;
I_TYPE  inode_fltr__s2;
I_TYPE  inode_fltr__s3;
I_TYPE  inode_fltr__s4;
I_TYPE  inode_fltr__s5;
I_TYPE  inode_fltr__s6;
I_TYPE  inode_fltr__s7;
I_TYPE  inode_fltr__s8;
I_TYPE  inode_fltr__s9;
I_TYPE  inode_fltr__g0;
I_TYPE  inode_fltr__g1;
I_TYPE  inode_fltr__g2;
I_TYPE  inode_fltr__g3;
I_TYPE  inode_fltr__g4;
I_TYPE  inode_fltr__g5;
I_TYPE  inode_fltr__g6;
I_TYPE  inode_fltr__g7;
I_TYPE  inode_fltr__g8;
I_TYPE  inode_fltr__g9;
I_TYPE  inode_fltr__g10;
I_TYPE  inode_fltr__y0;
I_TYPE  inode_fltr__y1;
I_TYPE  inode_fltr__y2;
I_TYPE  inode_fltr__y3;
I_TYPE  inode_fltr__y4;
I_TYPE  inode_fltr__y5;
I_TYPE  inode_fltr__y6;
I_TYPE  inode_fltr__y7;
I_TYPE  inode_fltr__y8;
I_TYPE  inode_out;
I_TYPE  inode__void0;


/* *** INCLUDE NAPA USER'S HEADER FILES *************************************************************************************** */

#include  "D:/Simulate/NapaDos/Hdr/napatool.hdr"
#include  "D:/Simulate/NapaDos/Hdr/Function/random.hdr"


/* *** DEFAULT PSEUDO-RANDOM NUMBER GENERATOR ********************************************************************************* */

#if !defined(EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR)
 #define NAPA_RAND  &napa_default_rand                                                            /*  pointer to function       */
 #define NAPA_SEED  &napa_default_seed                                                            /*  pointer to function       */
 #define NAPA_ROOT  &napa_default_root                                                            /*  pointer to function       */
#endif


/* *** MAIN ******************************************************************************************************************* */

int main(void) {

  napa_waypoint = 1;

  /* (ping functions defined in netlist)    */
  napa_ping(true);

  #ifdef __GNUC__
  /* (current working directory)            */
  if (NULL == getcwd(napa_cwd, 128)) {
    (void) strcpy(napa_cwd, "Unknown");
  }
  #endif

  /* (initialize control)                   */
  napa_control_init();
  napa_check_directives();
  napa_waypoint = 2;

  /* (initialize tool synchronization)      */
  napa_tool_setup();

  /* (initialize variables)                 */
  napa_reset_variables();

  /* (initialize nodes)                     */
  napa_reset_nodes();
  napa_waypoint = 3;

  /* (call user's check function)           */
  check_itool_tf_06("transfer_function.out",inode_in,1,inode_out,1,ivar_npts, 0);

  /* (call user's initialization function)  */
  init_itool_tf_06("transfer_function.out",inode_in,1,inode_out,1,ivar_npts, 0);

  /* (check output)                         */
  if ( !napa_output_flag ) {
    (void) fprintf(stderr,       "\nNAPA Run Time Warning:      (        I/O stream)\n");
    (void) fprintf(stderr,         " there is no explicit output from simulator.\n\n"  );
  }

  /* (start main loop)                      */
  napa_waypoint = 4;

  do {                                                                                            /*  @ f        1.000 MHz      */

    napa_rel_time  = napa_rel_loop * 1.000000000000000e-06L;
    napa_abs_time  = napa_abs_loop * 1.000000000000000e-06L;

    /* block 1 (update variables) is empty  */

    /* block 2 (update nodes)               */
    if ( true ) {                                                                                 /*  @ f        1.000 MHz      */
      inode_fltr__d20 = inode_fltr__d19;
      inode_fltr__d19 = inode_fltr__d18;
      inode_fltr__d18 = inode_fltr__d17;
      inode_fltr__d17 = inode_fltr__d16;
      inode_fltr__d16 = inode_fltr__d15;
      inode_fltr__d15 = inode_fltr__d14;
      inode_fltr__d14 = inode_fltr__d13;
      inode_fltr__d13 = inode_fltr__d12;
      inode_fltr__d12 = inode_fltr__d11;
      inode_fltr__d11 = inode_fltr__d10;
      inode_fltr__d10 = inode_fltr__d9;
      inode_fltr__d9 = inode_fltr__d8;
      inode_fltr__d8 = inode_fltr__d7;
      inode_fltr__d7 = inode_fltr__d6;
      inode_fltr__d6 = inode_fltr__d5;
      inode_fltr__d5 = inode_fltr__d4;
      inode_fltr__d4 = inode_fltr__d3;
      inode_fltr__d3 = inode_fltr__d2;
      inode_fltr__d2 = inode_fltr__d1;
      inode_fltr__d1 = inode_in;
      inode_in = (I_TYPE) ( rand_bernoulli ( 0.50 ) );
      inode_fltr__s0 = (inode_in) + (inode_fltr__d20);
      inode_fltr__s1 = (inode_fltr__d1) + (inode_fltr__d19);
      inode_fltr__s2 = (inode_fltr__d2) + (inode_fltr__d18);
      inode_fltr__s3 = (inode_fltr__d3) + (inode_fltr__d17);
      inode_fltr__s4 = (inode_fltr__d4) + (inode_fltr__d16);
      inode_fltr__s5 = (inode_fltr__d5) + (inode_fltr__d15);
      inode_fltr__s6 = (inode_fltr__d6) + (inode_fltr__d14);
      inode_fltr__s7 = (inode_fltr__d7) + (inode_fltr__d13);
      inode_fltr__s8 = (inode_fltr__d8) + (inode_fltr__d12);
      inode_fltr__s9 = (inode_fltr__d9) + (inode_fltr__d11);
      inode_fltr__g0 = ivar_fltr__h0 * inode_fltr__s0;
      inode_fltr__g1 = ivar_fltr__h1 * inode_fltr__s1;
      inode_fltr__g2 = ivar_fltr__h2 * inode_fltr__s2;
      inode_fltr__g3 = ivar_fltr__h3 * inode_fltr__s3;
      inode_fltr__g4 = ivar_fltr__h4 * inode_fltr__s4;
      inode_fltr__g5 = ivar_fltr__h5 * inode_fltr__s5;
      inode_fltr__g6 = ivar_fltr__h6 * inode_fltr__s6;
      inode_fltr__g7 = ivar_fltr__h7 * inode_fltr__s7;
      inode_fltr__g8 = ivar_fltr__h8 * inode_fltr__s8;
      inode_fltr__g9 = ivar_fltr__h9 * inode_fltr__s9;
      inode_fltr__g10 = ivar_fltr__h10 * inode_fltr__d10;
      inode_fltr__y0 = (inode_fltr__g0) + (inode_fltr__g1);
      inode_fltr__y1 = (inode_fltr__y0) + (inode_fltr__g2);
      inode_fltr__y2 = (inode_fltr__y1) + (inode_fltr__g3);
      inode_fltr__y3 = (inode_fltr__y2) + (inode_fltr__g4);
      inode_fltr__y4 = (inode_fltr__y3) + (inode_fltr__g5);
      inode_fltr__y5 = (inode_fltr__y4) + (inode_fltr__g6);
      inode_fltr__y6 = (inode_fltr__y5) + (inode_fltr__g7);
      inode_fltr__y7 = (inode_fltr__y6) + (inode_fltr__g8);
      inode_fltr__y8 = (inode_fltr__y7) + (inode_fltr__g9);
      inode_out = (inode_fltr__y8) + (inode_fltr__g10);
      napa_msg->o  = napa_packet;
      inode__void0 = itool_tf_06("transfer_function.out",inode_in,1,inode_out,1,ivar_npts, 0);
    }

    /* block 3 (output) is empty            */

    /* (update the mailbox of the tool)     */
    if ( napa_msg->o >= napa_packet ) {
      napa_rel_loop   = -1.0L;
      napa_tool_index = napa_packet;
      napa_msg->i     = START;
      napa_packet++;
    }

    /* (prepare next loop)                  */
    napa_abs_loop++;
    napa_rel_loop++;

  } while ( !TERMINATE );

  /* (main loop completed)                  */
  napa_waypoint = 5;

  /* (call user's closedown function)       */
  close_itool_tf_06("transfer_function.out",inode_in,1,inode_out,1,ivar_npts, 0);

  /* (end of simulation)                    */
  napa_waypoint = 6;
  napa_exit(EXIT_SUCCESS);

}


/* *** NAPA SIMULATOR FUNCTIONS *********************************************************************************************** */

void napa_control_init(void) {
  srand((unsigned int) (RANDOM_SEED % ((I_TYPE) RAND_MAX)));
  napa_seed = NAPA_SEED;
  napa_root = NAPA_ROOT;
  napa_rand = NAPA_RAND;
  napa_wall_clock  = clock();
  napa_random_seed = napa_seed(RANDOM_SEED);
  napa_init();
  if ( 0 != atexit(napa_end) ) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (atexit)\n");
    (void) fprintf(stderr,         " registering of 'napa_end()' did not succeed\n" );
    napa_exit(EXIT_FAILURE);
  }
  if ( 0 != atexit(napa_close) ) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (atexit)\n");
    (void) fprintf(stderr,         " registering of 'napa_close()' did not succeed\n");
    napa_exit(EXIT_FAILURE);
  }
  return;
}


void napa_tool_setup(void) {
  napa_msg    = &(napa_mailbox[0]);
  (void) strcpy(napa_msg->u, "inode__void0");
  (void) strcpy(napa_msg->t, "itool_tf");
  napa_msg->m =  0L;
  napa_msg->s =  0L;
  napa_msg->i =  START;
  napa_msg->o = -1LL;
  napa_msg->n =  0L;
  napa_msg->store_i = (long*)    NULL;
  napa_msg->store_l = (I_TYPE*)  NULL;
  napa_msg->store_d = (R_TYPE*)  NULL;
  napa_msg->store_s = (C_TYPE**) NULL;
  napa_tool_index = napa_packet - 1LL;
  return;
}


void napa_reset_variables(void) {
  ivar_npts = POWEROF2(16);
  ivar_fltr__h0 = 0;
  ivar_fltr__h1 = -1;
  ivar_fltr__h2 = 0;
  ivar_fltr__h3 = 5;
  ivar_fltr__h4 = 7;
  ivar_fltr__h5 = -3;
  ivar_fltr__h6 = -17;
  ivar_fltr__h7 = -12;
  ivar_fltr__h8 = 25;
  ivar_fltr__h9 = 76;
  ivar_fltr__h10 = 100;
  (void) fprintf(stderr,         "\n");
  return;
}

void napa_reset_nodes(void) {
  inode_fltr__d20 = DIGITAL_INI;
  inode_fltr__d19 = DIGITAL_INI;
  inode_fltr__d18 = DIGITAL_INI;
  inode_fltr__d17 = DIGITAL_INI;
  inode_fltr__d16 = DIGITAL_INI;
  inode_fltr__d15 = DIGITAL_INI;
  inode_fltr__d14 = DIGITAL_INI;
  inode_fltr__d13 = DIGITAL_INI;
  inode_fltr__d12 = DIGITAL_INI;
  inode_fltr__d11 = DIGITAL_INI;
  inode_fltr__d10 = DIGITAL_INI;
  inode_fltr__d9 = DIGITAL_INI;
  inode_fltr__d8 = DIGITAL_INI;
  inode_fltr__d7 = DIGITAL_INI;
  inode_fltr__d6 = DIGITAL_INI;
  inode_fltr__d5 = DIGITAL_INI;
  inode_fltr__d4 = DIGITAL_INI;
  inode_fltr__d3 = DIGITAL_INI;
  inode_fltr__d2 = DIGITAL_INI;
  inode_fltr__d1 = DIGITAL_INI;
  inode_in = DIGITAL_INI;
  inode_fltr__s0 = DIGITAL_INI;
  inode_fltr__s1 = DIGITAL_INI;
  inode_fltr__s2 = DIGITAL_INI;
  inode_fltr__s3 = DIGITAL_INI;
  inode_fltr__s4 = DIGITAL_INI;
  inode_fltr__s5 = DIGITAL_INI;
  inode_fltr__s6 = DIGITAL_INI;
  inode_fltr__s7 = DIGITAL_INI;
  inode_fltr__s8 = DIGITAL_INI;
  inode_fltr__s9 = DIGITAL_INI;
  inode_fltr__g0 = DIGITAL_INI;
  inode_fltr__g1 = DIGITAL_INI;
  inode_fltr__g2 = DIGITAL_INI;
  inode_fltr__g3 = DIGITAL_INI;
  inode_fltr__g4 = DIGITAL_INI;
  inode_fltr__g5 = DIGITAL_INI;
  inode_fltr__g6 = DIGITAL_INI;
  inode_fltr__g7 = DIGITAL_INI;
  inode_fltr__g8 = DIGITAL_INI;
  inode_fltr__g9 = DIGITAL_INI;
  inode_fltr__g10 = DIGITAL_INI;
  inode_fltr__y0 = DIGITAL_INI;
  inode_fltr__y1 = DIGITAL_INI;
  inode_fltr__y2 = DIGITAL_INI;
  inode_fltr__y3 = DIGITAL_INI;
  inode_fltr__y4 = DIGITAL_INI;
  inode_fltr__y5 = DIGITAL_INI;
  inode_fltr__y6 = DIGITAL_INI;
  inode_fltr__y7 = DIGITAL_INI;
  inode_fltr__y8 = DIGITAL_INI;
  inode_out = DIGITAL_INI;
  inode__void0 = DIGITAL_INI;
  return;
}


/* *** TRIVIAL CASE, NO OPTION FOUND IN USER'S AND/OR TOOL'S CALLS ************************************************************ */

double *napa_check_for_option(char *strfun, long id, char *stropt, int ctr) {      /* 'ctr' 0: a parameter, 'ctr' 1: an option  */
  static double zero = 0.0;
  if ( 0 == ctr ) {
    return (double*) NULL;
  } else {
    return &zero;
  }
}


/* *** GENERATE WARNINGS ONLY WHEN DIRECTIVES ARE NOT REGISTERED IN USER DEFINED FUNCTIONS AS EXPECTED ************************ */

void napa_check_directives(void) {
#if !defined(REPEAT_IS_REGISTERED)
  (void) fprintf(stderr,           "NAPA Run Time Warning:      (         directive)\n");
  (void) fprintf(stderr,           " -> at line   7 of main netlist\n");
  (void) fprintf(stderr,           "    The directive <REPEAT> is not REGISTERED\n\n");
  napa_timer(1L);
#endif
  return;
}


/* *** EXTENDED I/O RESOURCES MANAGER *** [Case Insensitive OS] *************************************************************** */
/* *** OPERATIONS:     OPENREAD, REWIND, OPENWRITE, OPENAPPEND, REWRITE, CLOSE, DELETE, QUERY, DEBUG, FREE                      */

IO_COMMAND napa_IO_manager(IO_COMMAND command, FILE **fp, char *filename, char *suffix, char *tag) {
  static long  id = 0L;
  const size_t sz = 255;
  char user[256]  = {'\0'};
  char nam1[256]  = {'\0'};
  char nam2[256]  = {'\0'};
  char nam3[256]  = {'\0'};
  char str[3]     = "  ";
  long i, j, index, length;
  int  iflag, oflag;
  iflag = false;
  oflag = false;
  if ( EOF == fflush((FILE*) NULL) ) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
    (void) fprintf(stderr,         " Flushing data from buffers I/O was not successful\n"   );
    napa_exit(EXIT_FAILURE);
  }
  if ( FREE != command ) {
    length = (long) strlen(filename);
    if ( 0L == length ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " The I/O stream name is missing\n");
      napa_exit(EXIT_FAILURE);
    }
    length = MIN(1L + length + ((long) strlen(suffix)), (long) sz);
    (void) snprintf(user, (size_t) length, "%s", filename);
    if ( (char*) NULL == strstr(user, ".") ) {
      if ( (0 != strncmp("stdin", user, sz)) && (0 != strncmp("stdout", user, sz)) && (0 != strncmp("stderr", user, sz)) ) {
        (void) strcat(user, suffix);
      }
    }
    for (i = 0L; i < ((long) strlen(user)); i++) {
      nam1[i] = (char) tolower((int) user[i]);
    }
    index = -1L;
    for (i = 0L; i < napa_IO_count; i++) {
      for (j = 0L; j <= ((long) strlen(napa_IO_record[i].user)); j++) {
        nam2[j] = (char) tolower((int) ((napa_IO_record[i].user)[j]));
      }
      if ( 0 == strncmp(nam1, nam2, sz) ) {
        index = i;
        if ( 0 != strncmp(napa_IO_record[index].user, user, sz) ) {
          (void) fprintf(stderr, "\nNAPA Run Time Error:        (I/O manager for %s)\n\n", tag);
          (void) fprintf(stderr,   " Collision between I/O streams in a case-insensitive context:");
          (void) fprintf(stderr,   " <%s> and <%s>\n\n", user, napa_IO_record[index].user);
          napa_exit(EXIT_FAILURE);
        }
        break;
      }
    }
  }
  (void) snprintf(nam3, sz, "%s.out", ORIGIN);
  for (i = 0L; i < ((long) strlen(nam3)); i++) {
    nam3[i] = (char) tolower((int) nam3[i]);
  }
  if ( 0 == strncmp(nam1, nam3, sz) ) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
    (void) fprintf(stderr,         " <%s>, the name of an I/O cannot be identical to a name possibly used as 'stdout'\n", user);
    napa_exit(EXIT_FAILURE);
  }
  switch (command) {
  case OPENWRITE_BINARY:
  case OPENAPPEND_BINARY:
    str[1] = 'b';
  case OPENWRITE:
  case OPENAPPEND:
  case REWRITE:
    if ( 0 == strncmp("stdin", user, sz) ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " The standard input stream <%s> cannot be opened for write\n", user);
      napa_exit(EXIT_FAILURE);
    }
    str[0] = ( (OPENAPPEND == command) || (OPENAPPEND_BINARY == command) ) ? 'a' : 'w';
    napa_output_flag = true;
    oflag  = true;
    break;
  case OPENREAD_BINARY:
    str[1] = 'b';
  case OPENREAD:
    if ( (0 == strncmp("stdout", user, sz)) || (0 == strncmp("stderr", user, sz)) ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " The standard I/O stream <%s> cannot be opened for read\n", user);
      napa_exit(EXIT_FAILURE);
    }
    str[0] = 'r';
    iflag  = true;
    break;
  case REWIND:
    if ( (0 == strncmp("stdin", user, sz)) || (0 == strncmp("stdout", user, sz)) || (0 == strncmp("stderr", user, sz)) ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Rewind of standard I/O stream <%s> is not possible\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ( -1L == index ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Rewind of I/O stream <%s> is not possible as it has not been registered\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ( DELETE == napa_IO_record[index].mode ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Rewind of I/O stream <%s> is not possible as it has been deleted\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ( ((FILE*) NULL) == napa_IO_record[index].f_ptr ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Rewind of I/O stream <%s> is not possible as it is not currently open\n", user);
      napa_exit(EXIT_FAILURE);
    }
    rewind(napa_IO_record[index].f_ptr);
#if (defined(DEBUG_MODE_IO) || defined(ALL_DEBUG))
    (void) fprintf(stderr,         "NAPA Debug Information:     (Rewind I/O stream )");
    (void) fprintf(stderr,         " %18s for %-18s <- % .0Lf\n", user, tag, napa_abs_loop);
#endif
    return napa_IO_record[index].mode;
  case CLOSE:
    if ( -1L == index ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " The I/O stream <%s> cannot be closed as it has not been registered\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ( ((FILE*) NULL) == napa_IO_record[index].f_ptr ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " The I/O stream <%s> is already closed\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ( DELETE == napa_IO_record[index].mode ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " The I/O stream <%s> cannot be closed as it has been deleted\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ( (0 != strncmp("stdin", user, sz)) && (0 != strncmp("stdout", user, sz)) && (0 != strncmp("stderr", user, sz)) ) {
      if ( EOF == fclose(napa_IO_record[index].f_ptr) ) {
        (void) fprintf(stderr,   "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
        (void) fprintf(stderr,     " Unable to close I/O stream <%s>\n", user);
        napa_exit(EXIT_FAILURE);
      }
    }
    napa_IO_record[index].f_ptr = (FILE*) NULL;
    napa_IO_record[index].mode  = command;
#if (defined(DEBUG_MODE_IO) || defined(ALL_DEBUG))
    (void) fprintf(stderr,         "NAPA Debug Information:     (Close  I/O stream )");
    (void) fprintf(stderr,         " %18s for %-18s <- % .0Lf\n", user, tag, napa_abs_loop);
#endif
    *fp = (FILE*) NULL;
    return command;
  case DELETE:
    if ( (0 == strncmp("stdin", user, sz)) || (0 == strncmp("stdout", user, sz)) || (0 == strncmp("stderr", user, sz)) ) {
      return UNKNOWN;
    }
    if ( -1L == index ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " The I/O stream <%s> cannot be deleted as it has not been registered\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ( !napa_IO_record[index].oflag ) {
#if (defined(DEBUG_MODE_IO) || defined(ALL_DEBUG))
      (void) fprintf(stderr,     "\nNAPA Debug Information:     (I/O stream        )");
      (void) fprintf(stderr,       " The I/O stream <%s> is not deleted, as it was not produced during the simulation\n\n", user);
#endif
      return napa_IO_record[index].mode;
    }
    if ( ((FILE*) NULL) != napa_IO_record[index].f_ptr ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " The I/O stream <%s> cannot be deleted as it is not closed\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ( DELETE == napa_IO_record[index].mode ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " The I/O stream <%s> has already been deleted\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ( 0 != remove(napa_IO_record[index].user) ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " The deletion of I/O stream <%s> did not succeed\n", user);
      napa_exit(EXIT_FAILURE);
    }
    napa_IO_record[index].iflag = false;
    napa_IO_record[index].oflag = false;
    napa_IO_record[index].mode  = command;
#if (defined(DEBUG_MODE_IO) || defined(ALL_DEBUG))
    (void) fprintf(stderr,         "NAPA Debug Information:     (Delete I/O stream )");
    (void) fprintf(stderr,         " %18s for %-18s <- % .0Lf\n", user, tag, napa_abs_loop);
#endif
    return command;
  case QUERY:
    return ( -1L == index ) ? UNKNOWN : napa_IO_record[index].mode;
  case DEBUG:
    (void) fprintf(stderr,       "\nNAPA Debug Information:     (I/O stream        )");
    (void) fprintf(stderr,         " %18s for %-18s <- % .0Lf\n", user, tag, napa_abs_loop);
    (void) fprintf(stderr,         " This I/O stream");
    if ( -1L < index ) {
      if ( (napa_IO_record[index].iflag) && (napa_IO_record[index].oflag) ) {
        (void) fprintf(stderr,     ", which was used as input and output,");
      } else {
        if ( napa_IO_record[index].iflag ) {
          (void) fprintf(stderr,   ", which was used as input," );
        }
        if ( napa_IO_record[index].oflag ) {
          (void) fprintf(stderr,   ", which was used as output,");
        }
      }
      if ( DELETE == napa_IO_record[index].mode ) {
        (void) fprintf(stderr,     " has been deleted\n");
      } else {
        (void) fprintf(stderr,     " is currently in mode <%d>, ", napa_IO_record[index].mode);
        (void) fprintf(stderr,     " i.e. '%s'\n", IO_COMMAND_NAME(napa_IO_record[index].mode));
      }
    } else {
      (void) fprintf(stderr,       " has not been registered\n");
    }
    return command;
  case FREE:
    if ( 0L >= napa_IO_count ) {
      return command;
    }
    j = 0L;
    for (i = 0L; i < napa_IO_count; i++) {
      if ( (UNKNOWN == napa_IO_record[i].mode) || (DELETE == napa_IO_record[i].mode) ) {
        continue;
      }
      if ( CLOSE == napa_IO_record[i].mode ) {
#if ((defined(DEBUG_MODE_IO) || defined(ALL_DEBUG)) && defined(VERBOSE))
        (void) fprintf(stderr,     "NAPA Debug Information:     (Purge I/O stream  ) < record[%ld] >\n", napa_IO_record[i].id);
#endif
        free(napa_IO_record[i].user);
        napa_IO_record[i].user  = (char*) NULL;
      } else {
        (void) strcpy(napa_IO_record[j].user, napa_IO_record[i].user);
        napa_IO_record[j].f_ptr = napa_IO_record[i].f_ptr;
        napa_IO_record[j].id    = napa_IO_record[i].id;
        napa_IO_record[j].mode  = napa_IO_record[i].mode;
        napa_IO_record[j].iflag = napa_IO_record[i].iflag;
        napa_IO_record[j].oflag = napa_IO_record[i].oflag;
        j++;
      }
    }
    napa_IO_count = j;
#if ((defined(DEBUG_MODE_IO) || defined(ALL_DEBUG)) && defined(VERBOSE))
    if ( 0L < napa_IO_count ) {
      (void) fprintf(stderr,       "NAPA Debug Information:     (Purge  I/O stream )");
      (void) fprintf(stderr,       " %ld I/O records are still allocated\n", napa_IO_count);
    }
#endif
    return command;
  default:
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
    (void) fprintf(stderr,         " Unknown I/O stream management command <%d>\n", command);
    napa_exit(EXIT_FAILURE);
  }
  if ( -1L == index ) {
    napa_IO_record[napa_IO_count].user = (char*) calloc((size_t) (1L+length), sizeof(char));
    if ( (char*) NULL == napa_IO_record[napa_IO_count].user ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " A dynamic memory allocation error occurred while recording I/O stream <%s>\n", user);
      napa_exit(EXIT_FAILURE);
    }
  } else {
    if ( ((FILE*) NULL) != napa_IO_record[index].f_ptr ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " The I/O stream <%s> cannot be opened twice\n", user);
      napa_exit(EXIT_FAILURE);
    }
  }
  if        ( 0 == strncmp("stdin",  user, sz) ) {
    *fp = stdin;
  } else if ( 0 == strncmp("stdout", user, sz) ) {
    *fp = stdout;
  } else if ( 0 == strncmp("stderr", user, sz) ) {
    *fp = stderr;
  } else {
    *fp = fopen(user, str);
    if ( (FILE*) NULL == *fp ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Unable to open I/O file <%s>\n", user);
      napa_exit(EXIT_FAILURE);
    }
  }
  if ( -1L == index ) {
    (void) strcpy(napa_IO_record[napa_IO_count].user, user);
    napa_IO_record[napa_IO_count].f_ptr = *fp;
    napa_IO_record[napa_IO_count].id    = id;
    napa_IO_record[napa_IO_count].mode  = command;
    napa_IO_record[napa_IO_count].iflag = iflag || napa_IO_record[napa_IO_count].iflag;
    napa_IO_record[napa_IO_count].oflag = oflag || napa_IO_record[napa_IO_count].oflag;
#if ((defined(DEBUG_MODE_IO) || defined(ALL_DEBUG)) && defined(VERBOSE))
    (void) fprintf(stderr,         "NAPA Debug Information:     (Create I/O stream ) < record[%ld] >\n", id);
#endif
    id++;
    napa_IO_count++;
    if ( 63L <= napa_IO_count ) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Internal arrays overflow (max = 63 I/O) while registering I/O stream <%s>\n", user);
      napa_exit(EXIT_FAILURE);
    }
  } else {
    napa_IO_record[index].f_ptr = *fp;
    napa_IO_record[index].mode  = command;
    napa_IO_record[index].iflag = iflag || napa_IO_record[index].iflag;
    napa_IO_record[index].oflag = oflag || napa_IO_record[index].oflag;
  }
#if (defined(DEBUG_MODE_IO) || defined(ALL_DEBUG))
  (void) fprintf(stderr,           "NAPA Debug Information:     (Open   I/O stream )");
  (void) fprintf(stderr,           " %18s for %-18s <- % .0Lf\n", user, tag, napa_abs_loop);
#endif
  if ( REWRITE == command ) {
    (void) napa_IO_manager(CLOSE, fp, filename, suffix, tag);
  }
  return command;
}


/* *** SIMPLE EQUILIKELY DISTRIBUTED POSITIVE INTEGER NUMBER PSEUDO-RANDOM GENERATOR  (MATSUMOTO & NISHIMURA IMPROVED LCG) **** */

I_TYPE napa_rand_integer(I_TYPE range) {                                                           /*  Output in [0, range]     */
  unsigned long ulrnd;
  static unsigned long j = 1UL;
  ulrnd = ((unsigned long) rand()) & 0XFFFFFFFFUL;
  ulrnd = j + (1812433253UL * (ulrnd^(ulrnd >> 30)));
  j++;
  return ((I_TYPE) (ulrnd & 0XFFFFFFFFUL)) % (1LL + ABS(range));
}


/* *** SEED RANDOMIZER  (MATSUMOTO & NISHIMURA IMPROVED LCG) ****************************************************************** */

#if !defined(EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR)

I_TYPE napa_default_root(I_TYPE seed) {
  unsigned long ulrnd;
  static unsigned long j = 1UL;
  ulrnd = ((unsigned long) seed) & 0XFFFFFFFFUL;
  ulrnd = j + (1812433253UL * (ulrnd^(ulrnd >> 30)));
  j++;
  return (I_TYPE) (ulrnd & 0XFFFFFFFFUL);
}

#endif


/* *** PSEUDO-RANDOM NUMBER GENERATOR (MERSENNE TWISTER MT19937-64) *********************************************************** */
/* *** Its period is 2^19937-1, which is approximately equal to 10^6002                                                    **** */
/* *** Source: Takuji Nishimura and Makoto Matsumoto, version 2004/9/29                                                    **** */
/* *** Sligthly modified to fit NAPA V4.40c                                                                                **** */

#if !defined(EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR)

unsigned long long napa_random_mta[312];
int                napa_random_mti = 0;

I_TYPE napa_default_seed(I_TYPE seed) {
  time_t tsys;
  if ( 0LL == seed ) {
    tsys = time((time_t*) NULL);
    seed = ((I_TYPE) tsys) / 2LL;
  } else {
    seed = ABS(seed);
  }
  napa_random_mta[0] = (unsigned long long) napa_root(seed);
  for (napa_random_mti = 1; napa_random_mti < 312; napa_random_mti++) {
    napa_random_mta[napa_random_mti]  = napa_random_mta[napa_random_mti-1];
    napa_random_mta[napa_random_mti] ^= napa_random_mta[napa_random_mti-1] >> 62;
    napa_random_mta[napa_random_mti] *= 6364136223846793005ULL;
    napa_random_mta[napa_random_mti] += napa_random_mti;
  }
  return seed;
}

I_TYPE napa_default_rand(void) {
  int i;
  unsigned long long x;
  static unsigned long long mag01[2] = {0ULL, 0XB5026F5AA96619E9ULL};
  if ( 312 <= napa_random_mti ) {
    for (i = 0; i < 156; i++) {
      x = (napa_random_mta[  i] & 0XFFFFFFFF80000000ULL) | (napa_random_mta[i+1] & 0X7FFFFFFFULL);
      napa_random_mta[i] = napa_random_mta[i+156] ^ (x>>1) ^ mag01[(int) (x&1ULL)];
    }
    for (i = 156; i < 311; i++) {
      x = (napa_random_mta[  i] & 0XFFFFFFFF80000000ULL) | (napa_random_mta[i+1] & 0X7FFFFFFFULL);
      napa_random_mta[i] = napa_random_mta[i-156] ^ (x>>1) ^ mag01[(int) (x&1ULL)];
    }
    x =   (napa_random_mta[311] & 0XFFFFFFFF80000000ULL) | (napa_random_mta[  0] & 0X7FFFFFFFULL);
    napa_random_mta[311] = napa_random_mta[  155] ^ (x>>1) ^ mag01[(int) (x&1ULL)];
    napa_random_mti = 0;
  }
  x  = napa_random_mta[napa_random_mti++];
  x ^= (x >> 29) & 0X5555555555555555ULL;
  x ^= (x << 17) & 0X71D67FFFEDA60000ULL;
  x ^= (x << 37) & 0XFFF7EEE000000000ULL;
  x ^= (x >> 43);
  return (I_TYPE) (x >> 1);
}

#endif


/* *** PING FUNCTION ********************************************************************************************************** */

void napa_ping(int always) {                             /* localisation of functions identified in the netlist                 */
  static int done = false;
  if ( !always && done ) {
    return;
  }
  (void) fprintf(stderr,       "\n\n");
#if defined(itool_tf_IS_REGISTERED)
  napa_ping_itool_tf();                                  /* as defined by macro 'PING( itool_tf )'                              */
#else
  PING_FAIL(itool_tf);
#endif
#if defined(rand_bernoulli_IS_REGISTERED)
  napa_ping_rand_bernoulli();                            /* as defined by macro 'PING( rand_bernoulli )'                        */
#else
  PING_FAIL(rand_bernoulli);
#endif
  done = true;
  return;
}


/* *** TIMER FUNCTION (freeze for 'num' seconds) ****************************************************************************** */

void napa_timer(long num) {
  time_t time_start, time_stop;
  if ( 0L < num ) {
    time_start = time((time_t*) NULL);
    do {
      time_stop = time((time_t*) NULL);
    } while ( ((long) (time_stop-time_start)) <= num );
  }
  return;
}


/* *** EXIT FUNCTIONS ********************************************************************************************************* */

void napa_end(void) {
  if ( !napa_error_flag ) {
    (void) napa_IO_manager(FREE, (FILE**) NULL, (char*) NULL, (char*) NULL, "end");
    (void) fprintf(stderr,       "\n ****  Normal Termination %25s ****\n", " ");
  }
#if defined(VERBOSE) && defined(NAPA_EXIT_STATUS)
  (void) fprintf(stderr,           " ****  NAPA Exit Status: %10s < %d > %9s ****\n\n", " ", napa_waypoint, " ");
#endif
  return;
}

void napa_exit(int exit_code) {
  if ( EOF == fflush((FILE*) NULL) ) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (exit)");
    (void) fprintf(stderr,         " flushing data from I/O buffers was not successful\n");
    exit_code = EXIT_FAILURE;
  }
  if ( EXIT_FAILURE == exit_code ) {
    napa_error_flag = true;
    (void) fprintf(stderr,     "\n\n ****  ERROR detected ");
    switch (napa_waypoint) {
    case 1: (void) fprintf(stderr, "before the initialization of the simulation."                 ); break;
    case 2: (void) fprintf(stderr, "during the 1st part of the initialization of the simulation." ); break;
    case 3: (void) fprintf(stderr, "during the 2nd part of the initialization of the simulation." ); break;
    case 4: (void) fprintf(stderr, "at abs_loop #%.0Lf during the simulation.",      napa_abs_loop); break;
    case 5: (void) fprintf(stderr, "at abs_loop #%.0Lf when simulation is closing.", napa_abs_loop); break;
    case 6: (void) fprintf(stderr, "during the execution of the NAPA exit code."                  );
    }
    (void) fprintf(stderr,     "\n\n");
    TIMER(1L);
#if defined(NAPA_EXIT_STATUS)
    exit(napa_waypoint);
#else
    exit(EXIT_FAILURE);
#endif
  } else {
    exit(EXIT_SUCCESS);
  }
}


/* *** C CODE PRODUCED BY THE NAPA COMPILER IN 187  ms (WALL CLOCK) FOR 'Anonymous User' ************************************** */

