
/* *** CREATED BY NAPA  V4.02 [Win64] ***** Mon Jun 17 13:25:10 2019 ********************************************************** */

/* *** Ad Hoc Cycle-Based ANSI-C Simulator Compiled for Yves Leduc                                                          *** */

/* *** Author and support:  Yves Leduc                                                                                      *** */
/* *** Email:  Yves.Leduc@borogoves.eu                                                                                      *** */

/* ***                                                                                                                      *** */
/* ***                                                                                                                      *** */
/* *** Simulation of a Maloberti SWC Integrator                                                                             *** */
/* ***                                                                                                                      *** */
/* ***                                                                                                                      *** */

/* This ANSI-C [C11] code has been produced by the NAPA compiler from these 4 netlist files:                                    */

/*  (main)  -> "maloberti.tmp"                                                                                                  */
/*          -> "/simulate/napados/net/pwl/pwl_d.net"                                                                            */
/*          -> "/simulate/napados/net/swc_integrator/maloberti_integrator1_ni.net"                                              */
/*          -> "myintegrator.dat"                                                                                               */

/* These libraries have been referenced by the user in the NAPA compiler line command:                                          */

/*          -> Generic headers    : "/Simulate/NapaDos/Hdr"                                                                     */
/*          -> Generic cells      : "/Simulate/NapaDos/Net"                                                                     */
/*          -> Generic generators : "/Simulate/NapaDos/Gen"                                                                     */

/* According to the user's demand, the ping function is implemented and activated.                                              */

/* Main loop of the simulator is divided in 3 blocks containing code                                                            */
/* respectively for variable updates, node updates and time domain output.                                                      */

/* Simulator built for Windows OS, where file names are not case-sensitive.                                                     */

/* (char) coded with              :    1 byte   (C_TYPE)                                                                        */
/* (short int) coded with         :    2 bytes                                                                                  */
/* (int) coded with               :    4 bytes                                                                                  */
/* (long int) coded with          :    4 bytes  (P_TYPE)                                                                        */
/* (long long) coded with         :    8 bytes  (I_TYPE)                                                                        */
/* (float) coded with             :    4 bytes  (L_PREC)                                                                        */
/* (double float) coded with      :    8 bytes  (R_TYPE)                                                                        */
/* (long double float) coded with :   16 bytes  (H_PREC)                                                                        */
/* (size_t) coded with            :    8 bytes                                                                                  */
/* (void*) coded with             :    8 bytes                                                                                  */

/* Resolution of a double float   :   15 digits (R_TYPE)                                                                        */

/* Number of user's nodes         :    8                                                                                        */
/* Number of user's variables     :   15                                                                                        */
/* Number of user's directives    :    1                                                                                        */
/* Number of user's declarations  :   14                                                                                        */
/* Number of cell instantiations  :    3                                                                                        */
/* Maximum cell hierarchy depth   :    2                                                                                        */

/* Simulation rate                :   10.0000 GHz                                                                               */
/* Sampling frequency             :   10.0000 GHz                                                                               */

/* Internal pseudo-random generator uses a seed chosen randomly at COMPILATION time.                                            */
/* Use the RANDOM_SEED value defined below to restart a simulation in the same conditions.                                      */

/* Please report bugs or suggestions to 'Yves.Leduc@borogoves.eu'                                                               */


/* *** INCLUDE ANSI-C STANDARD HEADER FILES *********************************************************************************** */

#include <ctype.h>
#include <limits.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdbool.h>


/* *** MACRO CONSTANTS AND VARIABLES AVAILABLE TO USER ************************************************************************ */

#define  PLATFORM              "Win64"
#define  NAPA_VERSION          "V4.02 for " PLATFORM

#define  USER                  "Yves Leduc"
#define  CREATED               "Mon Jun 17 13:25:10 2019 by " USER
#define  NAPA_JOB_ID           "YL1961517110"                                                       /*  unique tag              */

#define  ORIGIN                "Maloberti"
#define  SOURCE                "Maloberti.tmp"                                                      /*  NAPA main file          */
#define  CODE                  "Maloberti.c"                                                        /*  corresponding C file    */

#define  HEADERS_LIB           "/Simulate/NapaDos/Hdr"
#define  CELLS_LIB             "/Simulate/NapaDos/Net"
#define  GENERATORS_LIB        "/Simulate/NapaDos/Gen"

#define  TITLE                 napa_title
#define  SHORT_TITLE           napa_title

#define  TERMINATE             (8.0e-6<TIME)

#define  NUM_OF_TIME_OUTPUTS   1L

#define  NUM_OF_SEGMENTS       1L
#define  SEGMENT               0L

#define  RANDOM_SEED           780385355LL                                                        /*  unique random seed        */
#define  ANTITHETIC            false

#define  TIME                  ((R_TYPE) napa_abs_time)
#define  REF_TIME              ((R_TYPE) napa_abs_time)
#define  ABS_TIME              ((R_TYPE) napa_abs_time)
#define  REL_TIME              ((R_TYPE) napa_abs_time)

#define  LOOP_INDEX            ((I_TYPE) napa_abs_loop)
#define  ABS_LOOP_INDEX        ((I_TYPE) napa_abs_loop)
#define  REL_LOOP_INDEX        ((I_TYPE) napa_abs_loop)

#define  SIM_RATE              1.000000000000000e+010
#define  FS                    1.000000000000000e+010
#define  FSL                   1.000000000000000e+010
#define  STL                   0LL

#define  NUM_INITIAL           0LL

#define  PERIODIC              true

#define  NAPA_WAYPOINT         (napa_waypoint)

#define  SEPARATOR             (napa_separator)

#define  ERROR_FLAG            (napa_error_flag)
#define  ASSERT_FLAG           false
#define  WALL_CLOCK            (((R_TYPE)(clock()-napa_wall_clock))/((R_TYPE)CLOCKS_PER_SEC))

#define  I_FORMAT              " % 11lld"                                                         /*  format by default         */
#define  X_FORMAT              " %#018llX"                                                        /*  format by default         */
#define  R_FORMAT              " % .12e"                                                          /*  format by default         */
#define  S_FORMAT              " %12s"                                                            /*  format by default         */

#define  ANALOG_INI            0.0
#define  DIGITAL_INI           0LL

#define  TRUE                  true
#define  FALSE                 false
#define  YES                   true
#define  NO                    false

#define  LITTLE_ENDIAN         1
#define  BIG_ENDIAN            0

#define  CPU_ARCHITECTURE      LITTLE_ENDIAN


/* *** MACRO FUNCTIONS MADE AVAILABLE TO USER ********************************************************************************* */

#define  ABS(x)                ((0.0<(x))?(x):-(x))
#define  SIGN(x)               ((0.0<(x))-(0.0>(x)))                               /* returns -1, 0 or 1                        */
#define  MIN(x,y)              (((x)<(y))?(x):(y))
#define  MAX(x,y)              (((x)>(y))?(x):(y))
#define  CLIP(x,l,h)           MIN(MAX((x),(l)),(h))

#define  ISINSIDE(x,l,h)       (((x)>=(l))&&((x)<=(h)))                            /* inside the interval                       */
#define  ISOUTSIDE(x,l,h)      (((x)<(l))||((x)>(h)))                              /* strictly outside the interval             */
#define  ISEQUAL(x,y)          (ABS((x)-(y))<=(EPSILON*(ABS(x)+ABS(y))))           /* relative comparison with a treshold       */
#define  ISNOTEQUAL(x,y)       (ABS((x)-(y))> (EPSILON*(ABS(x)+ABS(y))))           /* relative comparison with a treshold       */
#define  ISSMALL(x)            (EPSILON>=ABS(x))
#define  ISNOTSMALL(x)         (EPSILON< ABS(x))
#define  ISEVEN(x)             (0LL==(D2I(x)%2LL))
#define  ISODD(x)              (0LL!=(D2I(x)%2LL))
#define  ISINTEGER(x)          (D2I(x)==(x))

#define  ISTIME(t)             (((FSL*((t)-TIME))<0.5)&&((FSL*(TIME-(t)))<=0.5))   /* time inside the local sampling interval   */

#define  POWEROF2(n)           ((0LL<((I_TYPE)(n)))?(1LL<<((I_TYPE)(n))):1LL)

#define  MODULO(x,y)           ((x)-((y)*floor(((R_TYPE)(x))/((R_TYPE)(y)))))
#define  SIN(x)                ((R_TYPE)sinl((H_PREC)(x)))                         /* keep precision when x is large            */
#define  COS(x)                ((R_TYPE)cosl((H_PREC)(x)))                         /* keep precision when x is large            */
#define  SQRT(x)               sqrt(MAX(0.0,(x)))                                  /* avoid negative values                     */
#define  LOG(x)                log(MAX(EPSILON,(x)))                               /* avoid values below or equal to zero       */
#define  POW(x,y)              pow(MAX(0.0,(x)),(y))                               /* avoid negative values                     */
#define  ROOT(x,y)             pow(MAX(0.0,(x)),1.0/((R_TYPE)(y)))                 /* avoid negative values                     */
#define  LOG10(x)              log10(MAX(EPSILON,(x)))                             /* avoid values below or equal to zero       */
#define  POW10(y)              pow(10.0,(y))

#define  D2I(x)                ((0.0<(x))?(I_TYPE)((x)+0.5):(I_TYPE)((x)-0.5))
#define  I2D(n)                ((R_TYPE)(n))
#define  DB2LIN(x,r)           ((r)*POW10(0.05*(x)))
#define  LIN2DB(x,r)           (20.0*LOG10(((R_TYPE)(x))/((R_TYPE)(r))))
#define  DB2POW(x,r)           ((r)*POW10(0.10*(x)))
#define  POW2DB(x,r)           (10.0*LOG10(((R_TYPE)(x))/((R_TYPE)(r))))
#define  RAD2DEG(x)            (57.2957795130823209*((R_TYPE)(x)))
#define  DEG2RAD(x)            (0.01745329251994329577*((R_TYPE)(x)))

#define  LENGTH(s)             ((I_TYPE)strlen(s))

#define  LINDOMAIN(c,b,e)      ((b)+((c)*((e)-(b))))
#define  LOGDOMAIN(c,b,e)      ((b)*POW10((c)*LOG10(((R_TYPE)(e))/((R_TYPE)(b)))))
#define  LINSWEEP(c,b,e,n)     LINDOMAIN((((R_TYPE)(c))/((R_TYPE)((n)-1L))),(b),(e))
#define  LOGSWEEP(c,b,e,n)     LOGDOMAIN((((R_TYPE)(c))/((R_TYPE)((n)-1L))),(b),(e))

#define  RAND_01()             (1.11022302462515666e-16*( (R_TYPE)(napa_rand()>>10)))             /* output in interval [0,1]   */
#define  RAND_01_X()           (2.22044604925031332e-16*(((R_TYPE)(napa_rand()>>11))+0.5))        /* output in interval ]0,1[   */

#define  FSS(n)                1.000000000000000e+010                                             /* constant                   */
#define  STS(n)                0LL                                                                /* constant                   */
#define  NIS(n)                0LL                                                                /* constant                   */
#define  PS(n)                 true                                                               /* constant                   */

#define  SEGMENT_CONDITION(n)  true                                                               /* constant                   */
#define  TIMER(n)              napa_timer(n)                                                      /* insert a pause             */

#define  IO_MANAGER(c,f,n,s,t) napa_IO_manager(c,f,n,s,t)                                         /* for user & tool functions  */

#define  ISOPTION(f,i,o)       napa_check_for_option(f,i,o)                                       /* for user & tool functions  */
#define  ISNOTOPTION(f,i)      (ISOPTION(f,i,"_another_") && (!ISOPTION(f,i,"delayed_node")))     /* for user & tool functions  */
#define  ISDELAYED(f,i)        (ISOPTION(f,i,"delayed_node"))                                     /* for user functions         */

#define  PING(fun)                                          \
void napa_ping_ ## fun(void);                               \
void napa_ping_ ## fun(void) {                              \
  (void) fprintf(stderr,   "NAPA Ping Information:     ");  \
  (void) fprintf(stderr,   "function '%-29s", #fun "()'");  \
  (void) fprintf(stderr,   "from file \"%s\"", __FILE__ );  \
  (void) fprintf(stderr, "\n");                             \
  return;                                                   \
}

#define  PING_REGISTERED(fun)                               \
  napa_ping_ ## fun()

#define  NOT_REGISTERED(fun)                                \
  (void) fprintf(stderr,   "NAPA Ping Information:     ");  \
  (void) fprintf(stderr,   "function '%-29s", #fun "()'");  \
  (void) fprintf(stderr,   "cannot be located\n")


/* *** OPTIONAL NAPA DIRECTIVES TO CONFIGURE FURTHER THIS SIMULATION ********************************************************** */

/*  directive TIME_OFFSET    <H_PREC Number>                                                                                    */
/*  directive JITTER         <H_PREC Formula>                                                                                   */
/*  directive STRICTLY_NO_BANNER                                                                                                */
/*  directive NO_BANNER                                                                                                         */
/*  directive NO_TIME_OUTPUT                                                                                                    */
/*  directive EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR  <File Pathname>                                                          */
/*  directive NAPA_EXIT_STATUS                                                                                                  */

/*  debug     IO                                                                                                                */

/*  directive VERBOSE                                                                                                           */

/*  [Header files of the library may be configured with specific directives]                                                    */


/* *** DECLARE NAPA TYPES ***************************************************************************************************** */

typedef   long long I_TYPE;
typedef      double R_TYPE;
typedef        char C_TYPE;
typedef        long P_TYPE;

typedef       float L_PREC;
typedef long double H_PREC;

typedef enum {
  UNKNOWN,              /*   0  */
  CLOSE,                /*   1  */
  OPENREAD,             /*   2  */
  OPENREAD_BINARY,      /*   3  */
  OPENWRITE,            /*   4  */
  OPENWRITE_BINARY,     /*   5  */
  OPENAPPEND,           /*   6  */
  OPENAPPEND_BINARY,    /*   7  */
  QUERY,                /*   8  */
  REWIND,               /*   9  */
  REWRITE,              /*  10  */
  ALLOCATE,             /*  11  */
  FREE,                 /*  12  */
  DELETE,               /*  13  */
  RESET,                /*  14  */
  DEBUG                 /*  15  */
} IO_COMMAND;

typedef struct {
  C_TYPE     name[512];
  C_TYPE   **s_ptr;
  C_TYPE   **n_ptr;
  I_TYPE   **i_ptr;
  R_TYPE   **d_ptr;
  C_TYPE   **c_ptr;
  int        nflag;
  int        pflag;
  long       length;
  long       nrow;
  long       ncol;
} DATA_RECORD;

typedef struct {
  FILE      *f_ptr;
  C_TYPE    *user;
  long       id;
  IO_COMMAND mode;
  int        iflag;
  int        oflag;
} IO_RECORD;


/* *** DECLARE GLOBAL CONSTANTS *********************************************************************************************** */

const I_TYPE START              =  1LL;
const I_TYPE STOP               =  0LL;

const R_TYPE _pi_               =  3.141592653589793;
const R_TYPE _pi2_              =  1.570796326794897;
const R_TYPE _pi4_              =  0.7853981633974483;
const R_TYPE _pi8_              =  0.3926990816987242;
const R_TYPE _2pi_              =  6.283185307179586;
const R_TYPE _e_                =  2.718281828459045;

const H_PREC _PI_               =  3.141592653589793239L;
const H_PREC _PI2_              =  1.570796326794896619L;
const H_PREC _PI4_              =  0.7853981633974483096L;
const H_PREC _PI8_              =  0.3926990816987241548L;
const H_PREC _2PI_              =  6.283185307179586477L;
const H_PREC _E_                =  2.718281828459045235L;

const R_TYPE EPSILON            =  2.0e-015;                                                      /*  used as 'small' number    */


/* *** DECLARE GLOBAL VARIABLES *** (not to be used outside of this code) ***************************************************** */

C_TYPE     napa_title[41]       =  "Simulation of a Maloberti SWC Integrator";

int        napa_waypoint        =  0;

H_PREC     napa_abs_loop        =  0.0L;
H_PREC     napa_abs_time        =  0.0L;
H_PREC     napa_ref_time        =  0.0L;

I_TYPE     napa_random_seed     =  0LL;

long       napa_IO_count        =  0L;
IO_RECORD  napa_IO_record[63];

clock_t    napa_wall_clock      =  0;

int        napa_error_flag      =  false;

C_TYPE     napa_separator[256]  =  "\n\n";


/* *** DECLARE GLOBAL FUNCTION POINTERS *************************************************************************************** */

I_TYPE   (*napa_seed)(I_TYPE)   =  NULL;
I_TYPE   (*napa_rand)(void)     =  NULL;
I_TYPE   (*napa_root)(I_TYPE)   =  NULL;


/* *** NAPA FUNCTION PROTOTYPES *********************************************************************************************** */

void       napa_init(void);                                                       /*  see "/Simulate/NapaDos/Hdr/napatool.hdr"  */
void       napa_close(void);                                                      /*  see "/Simulate/NapaDos/Hdr/napatool.hdr"  */

void       napa_timer(long);
void       napa_exit(int);
void       napa_end(void);
void       napa_control_init(void);
void       napa_record_setup(IO_COMMAND);
void       napa_reset_variables(void);
void       napa_reset_nodes(void);
void       napa_file_banner(void);
void       napa_ping(int);
void       napa_check_directives(void);

int        napa_check_for_option(char*, long, char*);

IO_COMMAND napa_IO_manager(IO_COMMAND, FILE**, char*, char*, char*);
IO_COMMAND napa_record_manager(IO_COMMAND, DATA_RECORD*, long, long, long, char*);

I_TYPE     napa_default_seed(I_TYPE);                                                             /*  seed generator            */
I_TYPE     napa_default_rand(void);                                                               /*  random generator          */
I_TYPE     napa_default_root(I_TYPE);                                                             /*  seed randomizer           */


/* *** USER'S FUNCTION COMPILATION DIRECTIVES ********************************************************************************* */

#define COMPILE_duser_pwl    1                                                                    /*  1 instance  in netlist    */
#define COMPILE_duser_sarc   4                                                                    /*  4 instances in netlist    */

#define COMPILE_Maloberti_Integrator1_NI
#define COMPILE_print_blank_line
#define COMPILE_print_var
#define COMPILE_rand_normal
#define COMPILE_switch_d


/* *** USER'S COMPILATION DIRECTIVES ****************************************************************************************** */

#define LOGFILE
#define LOGFILE_IS_EMPTY


/* *** DECLARATIONS *********************************************************************************************************** */

/* (declare I/O's file handles)             */
FILE   *napa_fp_0      = (FILE*) NULL;

/* (declare variables)                      */
C_TYPE  s_var_fil1[9];
C_TYPE  s_var_fil2[17];
R_TYPE  d_var_int__C0;
R_TYPE  d_var_int__C1;
R_TYPE  d_var_int__C2;
R_TYPE  d_var_int__Cload;
R_TYPE  d_var_int__Ron;
R_TYPE  d_var_int__Roff;
R_TYPE  d_var_int__data_0__Adb;
R_TYPE  d_var_int__EA;
R_TYPE  d_var_int__RDS;
R_TYPE  d_var_int__OFFS;
R_TYPE  d_var_int__rsw1;
R_TYPE  d_var_int__rsw2;
R_TYPE  d_var_initvalue;

/* (declare nodes)                          */
I_TYPE  i_node_Clk1;
I_TYPE  i_node_Clk1_clock[2];
P_TYPE  p_node_Clk1_ptr1;
P_TYPE  p_node_Clk1_ptr2;
P_TYPE  p_node_Clk1_width;
P_TYPE  p_node_Clk1_ini;
I_TYPE  i_node_Clk2;
I_TYPE  i_node_Clk2_clock[2];
P_TYPE  p_node_Clk2_ptr1;
P_TYPE  p_node_Clk2_ptr2;
P_TYPE  p_node_Clk2_width;
P_TYPE  p_node_Clk2_ini;
R_TYPE  d_node_pwl__in;
R_TYPE  d_node_In;
R_TYPE  d_node_int__tag;
R_TYPE  d_node_O;
R_TYPE  d_node_A;
R_TYPE  d_node_B;

/* (declare arrays of pointers)             */
DATA_RECORD  record_int__parm;


/* *** INCLUDE NAPA USER'S HEADER FILES *************************************************************************************** */

#include  "/Simulate/NapaDos/Hdr/napatool.hdr"
#include  "/Simulate/NapaDos/Hdr/User/pwl.hdr"
#include  "/Simulate/NapaDos/Hdr/Max/SWC_Integrator/MIMO_Maloberti_Integrator1_NI.hdr"


/* *** DEFAULT PSEUDO-RANDOM NUMBER GENERATOR ********************************************************************************* */

#if !defined(EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR)
# define NAPA_RAND  &napa_default_rand                                                             /* pointer to function       */
# define NAPA_SEED  &napa_default_seed                                                             /* pointer to function       */
# define NAPA_ROOT  &napa_default_root                                                             /* pointer to function       */
#endif


/* *** MAIN ******************************************************************************************************************* */

int main(void) {

  napa_waypoint = 2;

  /* (ping functions defined in netlist)    */
  napa_ping(true);

  /* (initialize control)                   */
  napa_control_init();
  napa_check_directives();
  napa_waypoint = 3;

  /* (initialize variables)                 */
  napa_random_seed = napa_seed(RANDOM_SEED);
  napa_reset_variables();

  /* (initialize records)                   */
  napa_record_setup(ALLOCATE);

  /* (open I/O stream)                      */
  (void) IO_MANAGER(OPENWRITE, &napa_fp_0, "stdout", ".out", "output");

  /* (initialize nodes)                     */
  napa_reset_nodes();
  napa_waypoint = 4;

  /* (call user's check functions)          */
  check_duser_pwl_03(s_var_fil1,d_node_pwl__in,1, 0);
  check_duser_sarc_04(Maloberti_Integrator1_NI,&record_int__parm,d_node_In,d_var_initvalue, 0);
  check_duser_sarc_01(d_node_int__tag, 1);
  check_duser_sarc_01(d_node_int__tag, 2);
  check_duser_sarc_01(d_node_int__tag, 3);

  /* (call user's initialization functions) */
  init_duser_pwl_03(s_var_fil1,d_node_pwl__in,1, 0);
  init_duser_sarc_04(Maloberti_Integrator1_NI,&record_int__parm,d_node_In,d_var_initvalue, 0);
  init_duser_sarc_01(d_node_int__tag, 1);
  init_duser_sarc_01(d_node_int__tag, 2);
  init_duser_sarc_01(d_node_int__tag, 3);

  /* (write file banner opening)            */
  napa_file_banner();

  /* (start main loop)                      */
  napa_waypoint = 5;

  do {

    napa_abs_time  = napa_abs_loop * 1.000000000000000e-010L;

    /* block 1 (update variables)           */

    /* always */ {
      d_var_int__rsw1 = switch_d(i_node_Clk1,d_var_int__Roff,d_var_int__Ron);
      d_var_int__rsw2 = switch_d(i_node_Clk2,d_var_int__Roff,d_var_int__Ron);
    }

    /* block 2 (update nodes)               */

    /* always */ {
      p_node_Clk1_ptr2++;
      if (p_node_Clk1_width <= p_node_Clk1_ptr2) {
        p_node_Clk1_ptr1++;
        p_node_Clk1_ptr2 = 0L;
      }
      if (2L <= p_node_Clk1_ptr1) {
        p_node_Clk1_ptr1 = p_node_Clk1_ini;
      }
      i_node_Clk1 = i_node_Clk1_clock[p_node_Clk1_ptr1];
      p_node_Clk2_ptr2++;
      if (p_node_Clk2_width <= p_node_Clk2_ptr2) {
        p_node_Clk2_ptr1++;
        p_node_Clk2_ptr2 = 0L;
      }
      if (2L <= p_node_Clk2_ptr1) {
        p_node_Clk2_ptr1 = p_node_Clk2_ini;
      }
      i_node_Clk2 = i_node_Clk2_clock[p_node_Clk2_ptr1];
      d_node_pwl__in = ((R_TYPE) MAX(0.0,(TIME/(1.0))-(0.0)));
      d_node_In = duser_pwl_03(s_var_fil1,d_node_pwl__in,1, 0);
      d_node_int__tag = duser_sarc_04(Maloberti_Integrator1_NI,&record_int__parm,d_node_In,d_var_initvalue, 0);
      d_node_O = duser_sarc_01(d_node_int__tag, 1);
      d_node_A = duser_sarc_01(d_node_int__tag, 2);
      d_node_B = duser_sarc_01(d_node_int__tag, 3);
    }

    /* block 3 (time domain output)         */

    /* always */ {
#if !defined(NO_TIME_OUTPUT)
      (void) fprintf(napa_fp_0,    "%.15Le", napa_abs_time);
#endif
      (void) fprintf(napa_fp_0,    "  % .12e % .12e % .12e % .12e % 11lld % 11lld\n",
        d_node_In, d_node_O, d_node_A, d_node_B, i_node_Clk1, i_node_Clk2);
    }

    napa_abs_loop++;

  } while (!TERMINATE);

  /* (main loop completed)                  */
  napa_waypoint = 6;

  /* (write file banner closing)            */
  napa_file_banner();

  /* (close I/O stream)                     */
  (void) IO_MANAGER(CLOSE, &napa_fp_0, "stdout", ".out", "output");

  /* (call user's closedown functions)      */
  close_duser_pwl_03(s_var_fil1,d_node_pwl__in,1, 0);
  close_duser_sarc_04(Maloberti_Integrator1_NI,&record_int__parm,d_node_In,d_var_initvalue, 0);
  close_duser_sarc_01(d_node_int__tag, 1);
  close_duser_sarc_01(d_node_int__tag, 2);
  close_duser_sarc_01(d_node_int__tag, 3);

  /* (end of simulation)                    */
  napa_waypoint = 7;
  napa_exit(EXIT_SUCCESS);

}


/* *** NAPA SIMULATOR FUNCTIONS *********************************************************************************************** */

void napa_control_init(void) {
  napa_wall_clock = clock();
  napa_seed = NAPA_SEED;
  napa_root = NAPA_ROOT;
  napa_rand = NAPA_RAND;
  (void) napa_init();
  if (0 != atexit(napa_end)) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (napa_end)\n");
    (void) fprintf(stderr,         " atexit() registering of 'napa_end()' did not succeed\n");
    napa_exit(EXIT_FAILURE);
  }
  if (0 != atexit(napa_close)) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (napa_close)\n");
    (void) fprintf(stderr,         " atexit() registering of 'napa_close()' did not succeed\n");
    napa_exit(EXIT_FAILURE);
  }
  return;
}

void napa_reset_variables(void) {
  (void) strcpy(s_var_fil1, "mypwl.in");
  (void) strcpy(s_var_fil2, "myintegrator.dat");
  if (false == (0.0<1.0)) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (declare)\n");
    (void) fprintf(stderr,         " -> at line  13 of main netlist\n");
    (void) fprintf(stderr,         " -> at line  66 of \"/simulate/napados/net/pwl/pwl_d.net\"\n");
    (void) fprintf(stderr,       "\n    Condition  [ 0.0<1.0 ]  is not satisfied!\n");
    napa_exit(EXIT_FAILURE);
  }
  d_var_int__C0 = rand_normal(2.0e-12,50.0e-15);
  d_var_int__C1 = rand_normal(2.0e-12,20.0e-15);
  d_var_int__C2 = rand_normal(2.0e-12,20.0e-15);
  d_var_int__Cload = 2.0e-12;
  d_var_int__Ron = 100.0;
  d_var_int__Roff = 1.0e9;
  d_var_int__data_0__Adb = 60.0;
  d_var_int__EA = DB2LIN(d_var_int__data_0__Adb,1.0);
  d_var_int__RDS = 10.0e6;
  d_var_int__OFFS = 1.0e-3;
  d_var_int__rsw1 = switch_d(DIGITAL_INI,d_var_int__Roff,d_var_int__Ron);
  d_var_int__rsw2 = switch_d(DIGITAL_INI,d_var_int__Roff,d_var_int__Ron);
  (void) print_blank_line();
  (void) print_var(d_var_int__C0,"F");
  (void) print_var(d_var_int__C1,"F");
  (void) print_var(d_var_int__C2,"F");
  (void) print_var(d_var_int__Cload,"F");
  (void) print_blank_line();
  (void) print_var(d_var_int__RDS,"Ohm");
  (void) print_var(d_var_int__OFFS,"V");
  (void) print_blank_line();
  d_var_initvalue = 0.5;
  (void) print_var(d_var_initvalue,"V");
  (void) fprintf(stderr,   "\n");
  return;
}

void napa_reset_nodes(void) {
  i_node_Clk1 = DIGITAL_INI;
  i_node_Clk1_clock[0L] = 1LL;
  i_node_Clk1_clock[1L] = 0LL;
  p_node_Clk1_ini   =  0L;
  p_node_Clk1_ptr1  =  0L;
  p_node_Clk1_ptr2  = -1L;
  p_node_Clk1_width = (P_TYPE) 5000;
  i_node_Clk2 = DIGITAL_INI;
  i_node_Clk2_clock[0L] = 0LL;
  i_node_Clk2_clock[1L] = 1LL;
  p_node_Clk2_ini   =  0L;
  p_node_Clk2_ptr1  =  0L;
  p_node_Clk2_ptr2  = -1L;
  p_node_Clk2_width = (P_TYPE) 5000;
  d_node_pwl__in = ANALOG_INI;
  d_node_In = ANALOG_INI;
  d_node_int__tag = ANALOG_INI;
  d_node_O = ANALOG_INI;
  d_node_A = ANALOG_INI;
  d_node_B = ANALOG_INI;
  return;
}

void napa_record_setup(IO_COMMAND command) {
  static char *int__parm[2][9] =                                              /* transfer of parameters by name                 */
    {{ "int__C0", "int__C1", "int__C2", "int__Cload", "int__EA", "int__OFFS", "int__RDS", "int__rsw1", "int__rsw2" },
     {      "C0",      "C1",      "C2",      "Cload",      "EA",      "Offs",      "RDS",      "PHIa",      "PHIb" }};
  (void) napa_record_manager(command, &record_int__parm, 9L, 1L, 9L, "int__parm");
  switch (command) {
  case ALLOCATE:
    record_int__parm.s_ptr     = int__parm[0];
    record_int__parm.n_ptr     = int__parm[1];
    record_int__parm.d_ptr[ 0] = &d_var_int__C0;
    record_int__parm.d_ptr[ 1] = &d_var_int__C1;
    record_int__parm.d_ptr[ 2] = &d_var_int__C2;
    record_int__parm.d_ptr[ 3] = &d_var_int__Cload;
    record_int__parm.d_ptr[ 4] = &d_var_int__EA;
    record_int__parm.d_ptr[ 5] = &d_var_int__OFFS;
    record_int__parm.d_ptr[ 6] = &d_var_int__RDS;
    record_int__parm.d_ptr[ 7] = &d_var_int__rsw1;
    record_int__parm.d_ptr[ 8] = &d_var_int__rsw2;
    record_int__parm.nflag     = true;
    record_int__parm.pflag     = false;
    break;
  case RESET:
  case FREE:
    break;
  case DEBUG:
    if ((4 > napa_waypoint) || (6 < napa_waypoint)) {
      (void) fprintf(stderr,     "\nNAPA Debug Information:     (array of pointers)\n");
      (void) fprintf(stderr,       "  simulation loop # %lld\n", LOOP_INDEX);
      (void) fprintf(stderr,       "  the pointers of all arrays are currently pointing to NULL\n");
      break;
    }
    (void) fprintf(stderr,       "\nNAPA Debug Information:     (array of pointers: int__parm[9])\n");
    (void) fprintf(stderr,         "  simulation loop # %lld\n", LOOP_INDEX);
    (void) fprintf(stderr,         "  ( analog)    int__C0    = % 14e\n", *(record_int__parm.d_ptr)[0]);
    (void) fprintf(stderr,         "  ( analog)    int__C1    = % 14e\n", *(record_int__parm.d_ptr)[1]);
    (void) fprintf(stderr,         "  ( analog)    int__C2    = % 14e\n", *(record_int__parm.d_ptr)[2]);
    (void) fprintf(stderr,         "  ( analog)    int__Cload = % 14e\n", *(record_int__parm.d_ptr)[3]);
    (void) fprintf(stderr,         "  ( analog)    int__EA    = % 14e\n", *(record_int__parm.d_ptr)[4]);
    (void) fprintf(stderr,         "  ( analog)    int__OFFS  = % 14e\n", *(record_int__parm.d_ptr)[5]);
    (void) fprintf(stderr,         "  ( analog)    int__RDS   = % 14e\n", *(record_int__parm.d_ptr)[6]);
    (void) fprintf(stderr,         "  ( analog)    int__rsw1  = % 14e\n", *(record_int__parm.d_ptr)[7]);
    (void) fprintf(stderr,         "  ( analog)    int__rsw2  = % 14e\n", *(record_int__parm.d_ptr)[8]);
    (void) fprintf(stderr,       "\n");
    break;
  default:
    break;
  }
  return;
}

void napa_file_banner(void) {
#if defined(STRICTLY_NO_BANNER)
  return;
#else
  if ((3 == napa_waypoint) || (4 == napa_waypoint)) {
# if !defined(NO_BANNER)
    (void) fprintf(napa_fp_0,      "#  %s\n",                            TITLE);
    (void) fprintf(napa_fp_0,      "# (time domain output  )\n");
    (void) fprintf(napa_fp_0,      "# (compiler version    ) NAPA %s\n", NAPA_VERSION);
    (void) fprintf(napa_fp_0,      "# (source file         ) \"%s\"\n",  SOURCE);
    (void) fprintf(napa_fp_0,      "# (random seed         ) %lld\n",    RANDOM_SEED);
    (void) fprintf(napa_fp_0,      "# (output sampling rate) 10.0000 GHz\n");
#  if !defined(NO_TIME_OUTPUT)
    (void) fprintf(napa_fp_0,      "# (number of columns   ) 7\n#\n#\n#\n#\n#\n#\n");
#  else
    (void) fprintf(napa_fp_0,      "# (number of columns   ) 6\n#\n#\n#\n#\n#\n#\n");
#  endif
    (void) fprintf(napa_fp_0,      "# %s\n", CREATED);
# endif
  }
  if ((3 == napa_waypoint) || (4 == napa_waypoint) || (6 == napa_waypoint)) {
# if !defined(NO_TIME_OUTPUT)
    (void) fprintf(napa_fp_0,      "# absolute_time(s)     ");
# else
    (void) fprintf(napa_fp_0,      "#");
# endif
    (void) fprintf(napa_fp_0,      "                In(V)");
    (void) fprintf(napa_fp_0,      "                 O(V)");
    (void) fprintf(napa_fp_0,      "                 A(V)");
    (void) fprintf(napa_fp_0,      "                 B(V)");
    (void) fprintf(napa_fp_0,      "        Clk1");
    (void) fprintf(napa_fp_0,      "        Clk2\n");
  }
  if  (6 == napa_waypoint) {
# if !defined(NO_BANNER)
    (void) fprintf(napa_fp_0,      "#\n");
    (void) fprintf(napa_fp_0,      "# (end of output file  )\n");
# endif
  }
  if ((5 == napa_waypoint) && (!TERMINATE)) {
    (void) fprintf(napa_fp_0,      "%s", SEPARATOR);
  }
  return;
#endif
}


/* *** OPTIONS IN USER'S AND/OR TOOL'S CALLS AS DESCRIBED IN NETLIST ********************************************************** */

int napa_check_for_option(char *fun, long id, char *opt) {                                        /* (N options / M functions)  */
  long n;
  long o = -1L;
  long f = -1L;
  size_t sz = 63;
  const long  npls = 4L;
  const long  nopt = 5L;
  const char *list_fun[2] = {"duser_pwl", "duser_sarc"};
  const char *list_opt[5] = {"aperiodic", "asymmetric", "V@OUT", "V@A", "V@B"};
  static int  table[2][4][5] =
    {{{ 1 , 1 , 0 , 0 , 0 },
      { 0 , 0 , 0 , 0 , 0 },
      { 0 , 0 , 0 , 0 , 0 },
      { 0 , 0 , 0 , 0 , 0 }},                     /*  <<<  duser_pwl   */
     {{ 0 , 0 , 0 , 0 , 0 },
      { 0 , 0 , 1 , 0 , 0 },
      { 0 , 0 , 0 , 1 , 0 },
      { 0 , 0 , 0 , 0 , 1 }}};                    /*  <<<  duser_sarc  */
  for (n = 0L; n < 2L; n++) {
    if (0 == strncmp(fun, list_fun[n], sz)) {
      f = n;
      break;
    }
  }
  if ((-1L == f) || (0L > id) || (npls <= id)) {
    return false;
  }
  if (0 == strncmp(opt, "_another_", sz)) {
    for (n = 0L; n < nopt; n++) {
      if (0 != table[f][id][n]) {
        return true;
      }
    }
    return false;
  }
  for (n = 0L; n < nopt; n++) {
    if (0 == strncmp(opt, list_opt[n], sz)) {
      o = n;
      break;
    }
  }
  if (-1L == o) {
    return false;
  }
  if (0 != table[f][id][o]) {
    table[f][id][o] = 0;
    return true;
  }
  return false;
}


/* *** GENERATE WARNINGS WHEN DIRECTIVES ARE NOT REGISTERED IN USER DEFINED FUNCTIONS ***************************************** */

void napa_check_directives(void) {
#if !defined(LOGFILE_IS_REGISTERED)
  (void) fprintf(stderr,           "NAPA Run Time Warning:      (         directive)\n");
  (void) fprintf(stderr,           " -> at line  22 of main netlist\n");
  (void) fprintf(stderr,           "    Directive <LOGFILE> is not registered\n\n");
  napa_timer(1L);
#endif
  return;
}


/* *** EXTENDED I/O RESOURCES MANAGER *** [Case Insensitive OS] *************************************************************** */
/* *** OPERATIONS:     OPENREAD, REWIND, OPENWRITE, OPENAPPEND, REWRITE, CLOSE, DELETE, QUERY, DEBUG, FREE                      */

IO_COMMAND napa_IO_manager(IO_COMMAND command, FILE **fp, char *filename, char *suffix, char *tag) {
  static long id = 0L;
  size_t sz      = 255;
  char user[256] = {'\0'};
  char nam1[256] = {'\0'};
  char nam2[256] = {'\0'};
  char str[3]    = "  ";
  long i, j, index, length;
  int  iflag, oflag;
  iflag = false;
  oflag = false;
  if (EOF == fflush(NULL)) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
    (void) fprintf(stderr,         " flushing data from buffers I/O was not successful\n");
    napa_exit(EXIT_FAILURE);
  }
  if (FREE != command) {
    length = (long) strlen(filename);
    if (0L == length) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream name is missing\n");
      napa_exit(EXIT_FAILURE);
    }
    length = 1L + MIN(length + ((long) strlen(suffix)), (long) sz);
    (void) snprintf(user, (size_t) length, "%s", filename);
    if ((char*) NULL == strstr(user, ".")) {
      if ((0 != strncmp(user, "stdin", sz)) && (0 != strncmp(user, "stdout", sz)) && (0 != strncmp(user, "stderr", sz))) {
        (void) strcat(user, suffix);
      }
    }
    for (i = 0L; i < length; i++) {
      nam1[i] = (char) tolower((int) user[i]);
    }
    index = -1L;
    for (i = 0L; i < napa_IO_count; i++) {
      for (j = 0L; j <= ((long) strlen(napa_IO_record[i].user)); j++) {
        nam2[j] = (char) tolower((int) ((napa_IO_record[i].user)[j]));
      }
      if (0 == strncmp(nam1, nam2, sz)) {
        index = i;
        if (0 != strncmp(user, napa_IO_record[index].user, sz)) {
          (void) fprintf(stderr, "\nNAPA Run Time Error:        (I/O manager for %s)\n\n", tag);
          (void) fprintf(stderr,   " Collision between I/O streams in a case-insensitive context:");
          (void) fprintf(stderr,   " <%s> and <%s>\n\n", user, napa_IO_record[index].user);
          napa_exit(EXIT_FAILURE);
        }
        break;
      }
    }
  }
  switch (command) {
  case OPENWRITE_BINARY:
  case OPENAPPEND_BINARY:
    str[1] = 'b';
  case OPENWRITE:
  case OPENAPPEND:
  case REWRITE:
    if (0 == strncmp(user, "stdin", sz)) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Standard Input <%s> cannot be opened for write\n", user);
      napa_exit(EXIT_FAILURE);
    }
    str[0] = ((OPENAPPEND == command) || (OPENAPPEND_BINARY == command)) ? 'a' : 'w';
    oflag  = true;
    break;
  case OPENREAD_BINARY:
    str[1] = 'b';
  case OPENREAD:
    if ((0 == strncmp(user, "stdout", sz)) || (0 == strncmp(user, "stderr", sz))) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Standard I/O stream <%s> cannot be opened for read\n", user);
      napa_exit(EXIT_FAILURE);
    }
    str[0] = 'r';
    iflag  = true;
    break;
  case REWIND:
    if ((0 == strncmp(user, "stdin", sz)) || (0 == strncmp(user, "stdout", sz)) || (0 == strncmp(user, "stderr", sz))) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Rewind of standard I/O stream <%s> is not possible\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if (-1L == index) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Rewind of I/O stream <%s> is not possible as it has not been registered\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if (DELETE == napa_IO_record[index].mode) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Rewind of I/O stream <%s> is not possible as it has been deleted\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ((FILE*) NULL == napa_IO_record[index].f_ptr) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Rewind of I/O stream <%s> is not possible as it is not currently open\n", user);
      napa_exit(EXIT_FAILURE);
    }
    rewind(napa_IO_record[index].f_ptr);
#if (defined(DEBUG_MODE_IO) || defined(ALL_DEBUG))
    (void) fprintf(stderr,         "NAPA Debug Information:     (Rewind I/O stream )");
    (void) fprintf(stderr,         " %18s for %-18s <- % .0Lf\n", user, tag, napa_abs_loop);
#endif
    return napa_IO_record[index].mode;
  case CLOSE:
    if (-1L == index) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream <%s> cannot be closed as it has not been registered\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ((FILE*) NULL == napa_IO_record[index].f_ptr) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream <%s> is already closed\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if (DELETE == napa_IO_record[index].mode) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream <%s> cannot be closed as it has been deleted\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ((0 != strncmp(user, "stdin", sz)) && (0 != strncmp(user, "stdout", sz)) && (0 != strncmp(user, "stderr", sz))) {
      if (EOF == fclose(napa_IO_record[index].f_ptr)) {
        (void) fprintf(stderr,   "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
        (void) fprintf(stderr,     " Unable to close I/O stream <%s>\n", user);
        napa_exit(EXIT_FAILURE);
      }
    }
    napa_IO_record[index].f_ptr = (FILE*) NULL;
    napa_IO_record[index].mode  = command;
#if (defined(DEBUG_MODE_IO) || defined(ALL_DEBUG))
    (void) fprintf(stderr,         "NAPA Debug Information:     (Close  I/O stream )");
    (void) fprintf(stderr,         " %18s for %-18s <- % .0Lf\n", user, tag, napa_abs_loop);
#endif
    *fp = (FILE*) NULL;
    return command;
  case DELETE:
    if ((0 == strncmp(user, "stdin", sz)) || (0 == strncmp(user, "stdout", sz)) || (0 == strncmp(user, "stderr", sz))) {
      return UNKNOWN;
    }
    if (-1L == index) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream <%s> cannot be deleted as it has not been registered\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if (0 == napa_IO_record[index].oflag) {
#if (defined(DEBUG_MODE_IO) || defined(ALL_DEBUG))
      (void) fprintf(stderr,     "\nNAPA Debug Information:     (I/O stream        )");
      (void) fprintf(stderr,       " I/O stream <%s> is not deleted, it has not been produced during this simulation\n\n", user);
#endif
      return napa_IO_record[index].mode;
    }
    if ((FILE*) NULL != napa_IO_record[index].f_ptr) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream <%s> cannot be deleted as it is not closed\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if (DELETE == napa_IO_record[index].mode) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream <%s> has already been deleted\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if (0 != remove(napa_IO_record[index].user)) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " deleting I/O stream <%s> did not succeed\n", user);
      napa_exit(EXIT_FAILURE);
    }
    napa_IO_record[index].iflag = 0;
    napa_IO_record[index].oflag = 0;
    napa_IO_record[index].mode  = command;
#if (defined(DEBUG_MODE_IO) || defined(ALL_DEBUG))
    (void) fprintf(stderr,         "NAPA Debug Information:     (Delete I/O stream )");
    (void) fprintf(stderr,         " %18s for %-18s <- % .0Lf\n", user, tag, napa_abs_loop);
#endif
    return command;
  case QUERY:
    return (-1L == index) ? UNKNOWN : napa_IO_record[index].mode;
  case DEBUG:
    (void) fprintf(stderr,       "\nNAPA Debug Information:     (I/O stream        )");
    (void) fprintf(stderr,         " %18s for %-18s <- % .0Lf\n", user, tag, napa_abs_loop);
    (void) fprintf(stderr,         " This stream");
    if (-1L < index) {
      if (0 < napa_IO_record[index].iflag) {
        (void) fprintf(stderr,     ", used as input");
      }
      if (0 < napa_IO_record[index].oflag) {
        (void) fprintf(stderr,     ", used as output");
      }
      if (DELETE == napa_IO_record[index].mode) {
        (void) fprintf(stderr,     " has been deleted\n");
      } else {
        (void) fprintf(stderr,     ", is currently in mode <%d>\n", napa_IO_record[index].mode);
      }
    } else {
      (void) fprintf(stderr,       " has not been registered\n");
    }
    return command;
  case FREE:
    if (0L >= napa_IO_count) {
      return command;
    }
    j = 0L;
    for (i = 0L; i < napa_IO_count; i++) {
      if ((UNKNOWN == napa_IO_record[i].mode) || (DELETE == napa_IO_record[i].mode)) {
        continue;
      }
      if (CLOSE == napa_IO_record[i].mode) {
#if ((defined(DEBUG_MODE_IO) || defined(ALL_DEBUG)) && defined(VERBOSE))
        (void) fprintf(stderr,     "NAPA Debug Information:     (Purge  I/O stream )");
        (void) fprintf(stderr,     " I/O record #%-2ld is freed\n", napa_IO_record[i].id);
#endif
        free(napa_IO_record[i].user);
        napa_IO_record[i].user  = (char*) NULL;
      } else {
        (void) strcpy(napa_IO_record[j].user, napa_IO_record[i].user);
        napa_IO_record[j].f_ptr = napa_IO_record[i].f_ptr;
        napa_IO_record[j].id    = napa_IO_record[i].id;
        napa_IO_record[j].mode  = napa_IO_record[i].mode;
        napa_IO_record[j].iflag = napa_IO_record[i].iflag;
        napa_IO_record[j].oflag = napa_IO_record[i].oflag;
        j++;
      }
    }
    napa_IO_count = j;
#if ((defined(DEBUG_MODE_IO) || defined(ALL_DEBUG)) && defined(VERBOSE))
    if (0L < napa_IO_count) {
      (void) fprintf(stderr,       "NAPA Debug Information:     (Purge  I/O stream )");
      (void) fprintf(stderr,       " %ld I/O records still allocated\n", napa_IO_count);
    }
#endif
    return command;
  default:
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
    (void) fprintf(stderr,         " Unknown I/O stream management command <%d>\n", command);
    napa_exit(EXIT_FAILURE);
  }
  if (-1L == index) {
    napa_IO_record[napa_IO_count].user = (char*) calloc((size_t) (1L+length), sizeof(char));
    if ((char*) NULL == napa_IO_record[napa_IO_count].user) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Dynamic memory allocation error while recording I/O stream <%s>\n", user);
      napa_exit(EXIT_FAILURE);
    }
  } else {
    if ((FILE*) NULL != napa_IO_record[index].f_ptr) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream <%s> cannot be opened twice\n", user);
      napa_exit(EXIT_FAILURE);
    }
  }
  if        (0 == strncmp(user, "stdin",  sz)) {
    *fp = stdin;
  } else if (0 == strncmp(user, "stdout", sz)) {
    *fp = stdout;
  } else if (0 == strncmp(user, "stderr", sz)) {
    *fp = stderr;
  } else {
    *fp = fopen(user, str);
    if ((FILE*) NULL == *fp) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Unable to open I/O file <%s>\n", user);
      napa_exit(EXIT_FAILURE);
    }
  }
  if (-1L == index) {
    (void) strcpy(napa_IO_record[napa_IO_count].user, user);
    napa_IO_record[napa_IO_count].f_ptr = *fp;
    napa_IO_record[napa_IO_count].id    = id;
    napa_IO_record[napa_IO_count].mode  = command;
    napa_IO_record[napa_IO_count].iflag = iflag || napa_IO_record[napa_IO_count].iflag;
    napa_IO_record[napa_IO_count].oflag = oflag || napa_IO_record[napa_IO_count].oflag;
#if ((defined(DEBUG_MODE_IO) || defined(ALL_DEBUG)) && defined(VERBOSE))
    (void) fprintf(stderr,         "NAPA Debug Information:     (Create I/O stream ) <record[%4ld]>\n", id);
#endif
    id++;
    napa_IO_count++;
    if (63L <= napa_IO_count) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Internal arrays overflow (max = 63 I/O) while registering I/O stream <%s>\n", user);
      napa_exit(EXIT_FAILURE);
    }
  } else {
    napa_IO_record[index].f_ptr = *fp;
    napa_IO_record[index].mode  = command;
    napa_IO_record[index].iflag = iflag || napa_IO_record[index].iflag;
    napa_IO_record[index].oflag = oflag || napa_IO_record[index].oflag;
  }
#if (defined(DEBUG_MODE_IO) || defined(ALL_DEBUG))
  (void) fprintf(stderr,           "NAPA Debug Information:     (Open   I/O stream )");
  (void) fprintf(stderr,           " %18s for %-18s <- % .0Lf\n", user, tag, napa_abs_loop);
#endif
  if (REWRITE == command) {
    (void) napa_IO_manager(CLOSE, fp, filename, suffix, tag);
  }
  return command;
}


/* **************************************************************************************************************************** */

IO_COMMAND napa_record_manager(IO_COMMAND command, DATA_RECORD *record, long length, long nrow, long ncol, char *name) {
  switch (command) {
  case ALLOCATE:
    (void) snprintf(record->name, (size_t) 127, "%s", name);
    record->length = length;
    record->nrow   = nrow;
    record->ncol   = ncol;
    record->i_ptr  = (I_TYPE**) calloc((size_t) length, sizeof (I_TYPE*));
    record->d_ptr  = (R_TYPE**) calloc((size_t) length, sizeof (R_TYPE*));
    record->c_ptr  = (C_TYPE**) calloc((size_t) length, sizeof (C_TYPE*));
    if (((I_TYPE**) NULL == record->i_ptr) || ((R_TYPE**) NULL == record->d_ptr) || ((C_TYPE**) NULL == record->c_ptr)) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (array of pointers)\n");
      (void) fprintf(stderr,       " Dynamic memory allocation error for <%s[%ld]>\n", name, length);
      napa_exit(EXIT_FAILURE);
    }                                                                                              /* no break                  */
  case RESET:
    if ('\0' != record->name[0]) {
      *record->i_ptr = (I_TYPE*) NULL;
      *record->d_ptr = (R_TYPE*) NULL;
      *record->c_ptr = (C_TYPE*) NULL;
    }
    break;
  case FREE:
    if ('\0' != record->name[0]) {
      record->name[0] = '\0';
      free(record->i_ptr);
      record->i_ptr = (I_TYPE**) NULL;
      free(record->d_ptr);
      record->d_ptr = (R_TYPE**) NULL;
      free(record->c_ptr);
      record->c_ptr = (C_TYPE**) NULL;
    }
    break;
  default:
    break;
  }
  return command;
}


/* *** SEED RANDOMIZER (MATSUMOTO & NISHIMURA IMPROVED LCG) ******************************************************************* */

#if !defined(EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR)

I_TYPE napa_default_root(I_TYPE seed) {
  unsigned long ulrnd;
  static unsigned long j = 1UL;
  ulrnd = ((unsigned long) seed) & 0XFFFFFFFFUL;
  ulrnd = (1812433253UL * (ulrnd^(ulrnd >> 30))) + j;
  j++;
  return (I_TYPE) (ulrnd & 0XFFFFFFFFUL);
}

#endif


/* *** PSEUDO-RANDOM NUMBER GENERATOR (MERSENNE TWISTER MT19937-64) *********************************************************** */
/* *** Source: Takuji Nishimura and Makoto Matsumoto, version 2004/9/29                                                    **** */
/* *** Modified to fit NAPA  V4.02                                                                                         **** */

#if !defined(EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR)

unsigned long long napa_random_mta[312];
int                napa_random_mti = 0;

I_TYPE napa_default_seed(I_TYPE seed) {
  time_t t;
  if (0LL == seed) {
    t = time(NULL);
    seed = ((I_TYPE) t) / 2LL;
  } else {
    seed = (0LL < seed) ? seed : -seed;
  }
  napa_random_mta[0] = (unsigned long long) napa_root(seed);
  for (napa_random_mti = 1; napa_random_mti < 312; napa_random_mti++) {
    napa_random_mta[napa_random_mti]  = napa_random_mta[napa_random_mti-1];
    napa_random_mta[napa_random_mti] ^= napa_random_mta[napa_random_mti-1] >> 62;
    napa_random_mta[napa_random_mti] *= 6364136223846793005ULL;
    napa_random_mta[napa_random_mti] += napa_random_mti;
  }
  return seed;
}

I_TYPE napa_default_rand(void) {
  int i;
  unsigned long long x;
  static unsigned long long mag01[2] = {0ULL, 0XB5026F5AA96619E9ULL};
  if (312 <= napa_random_mti) {
    for (i = 0; i < 156; i++) {
      x = (napa_random_mta[  i] & 0XFFFFFFFF80000000ULL) | (napa_random_mta[i+1] & 0X7FFFFFFFULL);
      napa_random_mta[i] = napa_random_mta[i+156] ^ (x>>1) ^ mag01[(int) (x&1ULL)];
    }
    for (i = 156; i < 311; i++) {
      x = (napa_random_mta[  i] & 0XFFFFFFFF80000000ULL) | (napa_random_mta[i+1] & 0X7FFFFFFFULL);
      napa_random_mta[i] = napa_random_mta[i-156] ^ (x>>1) ^ mag01[(int) (x&1ULL)];
    }
    x =   (napa_random_mta[311] & 0XFFFFFFFF80000000ULL) | (napa_random_mta[  0] & 0X7FFFFFFFULL);
    napa_random_mta[311] = napa_random_mta[  155] ^ (x>>1) ^ mag01[(int) (x&1ULL)];
    napa_random_mti = 0;
  }
  x  = napa_random_mta[napa_random_mti++];
  x ^= (x >> 29) & 0X5555555555555555ULL;
  x ^= (x << 17) & 0X71D67FFFEDA60000ULL;
  x ^= (x << 37) & 0XFFF7EEE000000000ULL;
  x ^= (x >> 43);
  return (I_TYPE) (x >> 1);
}

#endif


/* *** PING FUNCTION ********************************************************************************************************** */

void napa_ping(int always) {                                                                      /* localisation of functions  */
  static int done = false;
  if ((false != done) && (false == always)) {
    return;
  }
  (void) fprintf(stderr,       "\n\n");
#if defined(duser_pwl_IS_REGISTERED)
  PING_REGISTERED(duser_pwl);
#else
  NOT_REGISTERED(duser_pwl);
#endif
#if defined(duser_sarc_IS_REGISTERED)
  PING_REGISTERED(duser_sarc);
#else
  NOT_REGISTERED(duser_sarc);
#endif
#if defined(Maloberti_Integrator1_NI_IS_REGISTERED)
  PING_REGISTERED(Maloberti_Integrator1_NI);
#else
  NOT_REGISTERED(Maloberti_Integrator1_NI);
#endif
#if defined(print_blank_line_IS_REGISTERED)
  PING_REGISTERED(print_blank_line);
#else
  NOT_REGISTERED(print_blank_line);
#endif
#if defined(print_var_IS_REGISTERED)
  PING_REGISTERED(print_var);
#else
  NOT_REGISTERED(print_var);
#endif
#if defined(rand_normal_IS_REGISTERED)
  PING_REGISTERED(rand_normal);
#else
  NOT_REGISTERED(rand_normal);
#endif
#if defined(switch_d_IS_REGISTERED)
  PING_REGISTERED(switch_d);
#else
  NOT_REGISTERED(switch_d);
#endif
  done = true;
  return;
}


/* *** TIMER FUNCTION (seconds) *********************************************************************************************** */

void napa_timer(long cnt) {
  time_t time_start, time_stop;
  if (0L < cnt) {
    time_start = time(NULL);
    do {
      time_stop = time(NULL);
    } while (((long) (time_stop - time_start)) <= cnt);
  }
  return;
}


/* *** EXIT FUNCTIONS ********************************************************************************************************* */

void napa_end(void) {
  napa_record_setup(FREE);
  if (false == napa_error_flag) {
    (void) napa_IO_manager(FREE, (FILE**) NULL, (char*) NULL, (char*) NULL, "end");
    (void) fprintf(stderr,       "\n ****  Normal Termination %25s ****\n", " ");
  }
#if defined(VERBOSE) && defined(NAPA_EXIT_STATUS)
  (void) fprintf(stderr,           " ****  NAPA Exit Status: %10s < %d > %9s ****\n\n", " ", napa_waypoint, " ");
#endif
  return;
}

void napa_exit(int exit_code) {
  if (EOF == fflush(NULL)) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (exit)");
    (void) fprintf(stderr,         " flushing data from I/O buffers was not successful\n\n");
    exit_code = EXIT_FAILURE;
  }
  if (EXIT_FAILURE == exit_code) {
    napa_error_flag = true;
    (void) fprintf(stderr,     "\n\n ****  ERROR detected ");
    switch (napa_waypoint) {
      case 1:
      case 2: (void) fprintf(stderr, "before the initialization of the simulation."                ); break;
      case 3: (void) fprintf(stderr, "during the 1st part of the initialization of the simulation."); break;
      case 4: (void) fprintf(stderr, "during the 2nd part of the initialization of the simulation."); break;
      case 5: (void) fprintf(stderr, "at loop #%.0Lf during the simulation.",         napa_abs_loop); break;
      case 6: (void) fprintf(stderr, "at loop #%.0Lf when simulation is closing.",    napa_abs_loop); break;
      case 7: (void) fprintf(stderr, "during the execution of the NAPA exit code."                 ); break;
    }
    (void) fprintf(stderr,     "\n\n");
#ifdef NAPA_EXIT_STATUS
    exit(napa_waypoint);
#else
    exit(EXIT_FAILURE);
#endif
  } else {
    exit(EXIT_SUCCESS);
  }
}


/* *** FILE BUILT IN 62.0 ms (WALL CLOCK) FOR Yves Leduc ********************************************************************** */

