
/* *** CREATED BY NAPA  V4.02 [Win64] ***** Mon Jun 17 13:24:40 2019 ********************************************************** */

/* *** Ad Hoc Cycle-Based ANSI-C Simulator Compiled for Yves Leduc                                                          *** */

/* *** Author and support:  Yves Leduc                                                                                      *** */
/* *** Email:  Yves.Leduc@borogoves.eu                                                                                      *** */

/* ***                                                                                                                      *** */
/* ***                                                                                                                      *** */
/* *** variables and events                                                                                                 *** */
/* ***                                                                                                                      *** */
/* ***                                                                                                                      *** */

/* Main NAPA netlist file name  : "update.tmp"                                                                                  */

/* These libraries have been referenced by the user in the NAPA compiler line command:                                          */

/*          -> Generic headers    : "/Simulate/NapaDos/Hdr"                                                                     */
/*          -> Generic cells      : "/Simulate/NapaDos/Net"                                                                     */
/*          -> Generic generators : "/Simulate/NapaDos/Gen"                                                                     */

/* Main loop of the simulator is divided in 2 blocks containing code                                                            */

/* Simulator built for Windows OS, where file names are not case-sensitive.                                                     */

/* (char) coded with              :    1 byte   (C_TYPE)                                                                        */
/* (short int) coded with         :    2 bytes                                                                                  */
/* (int) coded with               :    4 bytes                                                                                  */
/* (long int) coded with          :    4 bytes  (P_TYPE)                                                                        */
/* (long long) coded with         :    8 bytes  (I_TYPE)                                                                        */
/* (float) coded with             :    4 bytes  (L_PREC)                                                                        */
/* (double float) coded with      :    8 bytes  (R_TYPE)                                                                        */
/* (long double float) coded with :   16 bytes  (H_PREC)                                                                        */
/* (size_t) coded with            :    8 bytes                                                                                  */
/* (void*) coded with             :    8 bytes                                                                                  */

/* Resolution of a double float   :   15 digits (R_TYPE)                                                                        */

/* Number of user's nodes         :    0                                                                                        */
/* Number of user's variables     :    4                                                                                        */

/* Simulation rate                :   1.00000  Hz                                                                               */
/* Sampling frequency             :   1.00000  Hz                                                                               */

/* Internal pseudo-random generator uses a seed chosen randomly at COMPILATION time.                                            */
/* Use the RANDOM_SEED value defined below to restart a simulation in the same conditions.                                      */

/* Please report bugs or suggestions to 'Yves.Leduc@borogoves.eu'                                                               */


/* *** INCLUDE ANSI-C STANDARD HEADER FILES *********************************************************************************** */

#include <ctype.h>
#include <limits.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdbool.h>


/* *** MACRO CONSTANTS AND VARIABLES AVAILABLE TO USER ************************************************************************ */

#define  PLATFORM              "Win64"
#define  NAPA_VERSION          "V4.02 for " PLATFORM

#define  USER                  "Yves Leduc"
#define  CREATED               "Mon Jun 17 13:24:40 2019 by " USER
#define  NAPA_JOB_ID           "YL1961517080"                                                       /*  unique tag              */

#define  ORIGIN                "update"
#define  SOURCE                "update.tmp"                                                         /*  NAPA main file          */
#define  CODE                  "update.c"                                                           /*  corresponding C file    */

#define  HEADERS_LIB           "/Simulate/NapaDos/Hdr"
#define  CELLS_LIB             "/Simulate/NapaDos/Net"
#define  GENERATORS_LIB        "/Simulate/NapaDos/Gen"

#define  TITLE                 napa_title
#define  SHORT_TITLE           napa_title

#define  TERMINATE             (100.0<=TIME)

#define  NUM_OF_TIME_OUTPUTS   2L

#define  NUM_OF_SEGMENTS       1L
#define  SEGMENT               0L

#define  RANDOM_SEED           780385340LL                                                        /*  unique random seed        */
#define  ANTITHETIC            false

#define  TIME                  ((R_TYPE) napa_abs_time)
#define  REF_TIME              ((R_TYPE) napa_abs_time)
#define  ABS_TIME              ((R_TYPE) napa_abs_time)
#define  REL_TIME              ((R_TYPE) napa_abs_time)

#define  LOOP_INDEX            ((I_TYPE) napa_abs_loop)
#define  ABS_LOOP_INDEX        ((I_TYPE) napa_abs_loop)
#define  REL_LOOP_INDEX        ((I_TYPE) napa_abs_loop)

#define  SIM_RATE              1.000000000000000e+000
#define  FS                    1.000000000000000e+000
#define  FSL                   1.000000000000000e+000
#define  STL                   0LL

#define  NUM_INITIAL           0LL

#define  PERIODIC              true

#define  NAPA_WAYPOINT         (napa_waypoint)

#define  SEPARATOR             (napa_separator)

#define  ERROR_FLAG            (napa_error_flag)
#define  ASSERT_FLAG           false
#define  WALL_CLOCK            (((R_TYPE)(clock()-napa_wall_clock))/((R_TYPE)CLOCKS_PER_SEC))

#define  I_FORMAT              " % 11lld"                                                         /*  format by default         */
#define  X_FORMAT              " %#018llX"                                                        /*  format by default         */
#define  R_FORMAT              " % .12e"                                                          /*  format by default         */
#define  S_FORMAT              " %12s"                                                            /*  format by default         */

#define  ANALOG_INI            0.0
#define  DIGITAL_INI           0LL

#define  TRUE                  true
#define  FALSE                 false
#define  YES                   true
#define  NO                    false

#define  LITTLE_ENDIAN         1
#define  BIG_ENDIAN            0

#define  CPU_ARCHITECTURE      LITTLE_ENDIAN


/* *** MACRO FUNCTIONS MADE AVAILABLE TO USER ********************************************************************************* */

#define  ABS(x)                ((0.0<(x))?(x):-(x))
#define  SIGN(x)               ((0.0<(x))-(0.0>(x)))                               /* returns -1, 0 or 1                        */
#define  MIN(x,y)              (((x)<(y))?(x):(y))
#define  MAX(x,y)              (((x)>(y))?(x):(y))
#define  CLIP(x,l,h)           MIN(MAX((x),(l)),(h))

#define  ISINSIDE(x,l,h)       (((x)>=(l))&&((x)<=(h)))                            /* inside the interval                       */
#define  ISOUTSIDE(x,l,h)      (((x)<(l))||((x)>(h)))                              /* strictly outside the interval             */
#define  ISEQUAL(x,y)          (ABS((x)-(y))<=(EPSILON*(ABS(x)+ABS(y))))           /* relative comparison with a treshold       */
#define  ISNOTEQUAL(x,y)       (ABS((x)-(y))> (EPSILON*(ABS(x)+ABS(y))))           /* relative comparison with a treshold       */
#define  ISSMALL(x)            (EPSILON>=ABS(x))
#define  ISNOTSMALL(x)         (EPSILON< ABS(x))
#define  ISEVEN(x)             (0LL==(D2I(x)%2LL))
#define  ISODD(x)              (0LL!=(D2I(x)%2LL))
#define  ISINTEGER(x)          (D2I(x)==(x))

#define  ISTIME(t)             (((FSL*((t)-TIME))<0.5)&&((FSL*(TIME-(t)))<=0.5))   /* time inside the local sampling interval   */

#define  POWEROF2(n)           ((0LL<((I_TYPE)(n)))?(1LL<<((I_TYPE)(n))):1LL)

#define  MODULO(x,y)           ((x)-((y)*floor(((R_TYPE)(x))/((R_TYPE)(y)))))
#define  SIN(x)                ((R_TYPE)sinl((H_PREC)(x)))                         /* keep precision when x is large            */
#define  COS(x)                ((R_TYPE)cosl((H_PREC)(x)))                         /* keep precision when x is large            */
#define  SQRT(x)               sqrt(MAX(0.0,(x)))                                  /* avoid negative values                     */
#define  LOG(x)                log(MAX(EPSILON,(x)))                               /* avoid values below or equal to zero       */
#define  POW(x,y)              pow(MAX(0.0,(x)),(y))                               /* avoid negative values                     */
#define  ROOT(x,y)             pow(MAX(0.0,(x)),1.0/((R_TYPE)(y)))                 /* avoid negative values                     */
#define  LOG10(x)              log10(MAX(EPSILON,(x)))                             /* avoid values below or equal to zero       */
#define  POW10(y)              pow(10.0,(y))

#define  D2I(x)                ((0.0<(x))?(I_TYPE)((x)+0.5):(I_TYPE)((x)-0.5))
#define  I2D(n)                ((R_TYPE)(n))
#define  DB2LIN(x,r)           ((r)*POW10(0.05*(x)))
#define  LIN2DB(x,r)           (20.0*LOG10(((R_TYPE)(x))/((R_TYPE)(r))))
#define  DB2POW(x,r)           ((r)*POW10(0.10*(x)))
#define  POW2DB(x,r)           (10.0*LOG10(((R_TYPE)(x))/((R_TYPE)(r))))
#define  RAD2DEG(x)            (57.2957795130823209*((R_TYPE)(x)))
#define  DEG2RAD(x)            (0.01745329251994329577*((R_TYPE)(x)))

#define  LENGTH(s)             ((I_TYPE)strlen(s))

#define  LINDOMAIN(c,b,e)      ((b)+((c)*((e)-(b))))
#define  LOGDOMAIN(c,b,e)      ((b)*POW10((c)*LOG10(((R_TYPE)(e))/((R_TYPE)(b)))))
#define  LINSWEEP(c,b,e,n)     LINDOMAIN((((R_TYPE)(c))/((R_TYPE)((n)-1L))),(b),(e))
#define  LOGSWEEP(c,b,e,n)     LOGDOMAIN((((R_TYPE)(c))/((R_TYPE)((n)-1L))),(b),(e))

#define  RAND_01()             (1.11022302462515666e-16*( (R_TYPE)(napa_rand()>>10)))             /* output in interval [0,1]   */
#define  RAND_01_X()           (2.22044604925031332e-16*(((R_TYPE)(napa_rand()>>11))+0.5))        /* output in interval ]0,1[   */

#define  FSS(n)                1.000000000000000e+000                                             /* constant                   */
#define  STS(n)                0LL                                                                /* constant                   */
#define  NIS(n)                0LL                                                                /* constant                   */
#define  PS(n)                 true                                                               /* constant                   */

#define  SEGMENT_CONDITION(n)  true                                                               /* constant                   */
#define  TIMER(n)              napa_timer(n)                                                      /* insert a pause             */

#define  IO_MANAGER(c,f,n,s,t) napa_IO_manager(c,f,n,s,t)

#define  PING(fun)                                                                                /* empty function             */


/* *** OPTIONAL NAPA DIRECTIVES TO CONFIGURE FURTHER THIS SIMULATION ********************************************************** */

/*  directive TIME_OFFSET    <H_PREC Number>                                                                                    */
/*  directive JITTER         <H_PREC Formula>                                                                                   */
/*  directive STRICTLY_NO_BANNER                                                                                                */
/*  directive NO_BANNER                                                                                                         */
/*  directive NO_TIME_OUTPUT                                                                                                    */
/*  directive EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR  <File Pathname>                                                          */
/*  directive NAPA_EXIT_STATUS                                                                                                  */

/*  debug     IO                                                                                                                */

/*  directive VERBOSE                                                                                                           */

/*  [Header files of the library may be configured with specific directives]                                                    */


/* *** DECLARE NAPA TYPES ***************************************************************************************************** */

typedef   long long I_TYPE;
typedef      double R_TYPE;
typedef        char C_TYPE;
typedef        long P_TYPE;

typedef       float L_PREC;
typedef long double H_PREC;

typedef enum {
  UNKNOWN,              /*   0  */
  CLOSE,                /*   1  */
  OPENREAD,             /*   2  */
  OPENREAD_BINARY,      /*   3  */
  OPENWRITE,            /*   4  */
  OPENWRITE_BINARY,     /*   5  */
  OPENAPPEND,           /*   6  */
  OPENAPPEND_BINARY,    /*   7  */
  QUERY,                /*   8  */
  REWIND,               /*   9  */
  REWRITE,              /*  10  */
  ALLOCATE,             /*  11  */
  FREE,                 /*  12  */
  DELETE,               /*  13  */
  RESET,                /*  14  */
  DEBUG                 /*  15  */
} IO_COMMAND;

typedef struct {
  C_TYPE     name[512];
  C_TYPE   **s_ptr;
  C_TYPE   **n_ptr;
  I_TYPE   **i_ptr;
  R_TYPE   **d_ptr;
  C_TYPE   **c_ptr;
  int        nflag;
  int        pflag;
  long       length;
  long       nrow;
  long       ncol;
} DATA_RECORD;

typedef struct {
  FILE      *f_ptr;
  C_TYPE    *user;
  long       id;
  IO_COMMAND mode;
  int        iflag;
  int        oflag;
} IO_RECORD;


/* *** DECLARE GLOBAL CONSTANTS *********************************************************************************************** */

const I_TYPE START              =  1LL;
const I_TYPE STOP               =  0LL;

const R_TYPE _pi_               =  3.141592653589793;
const R_TYPE _pi2_              =  1.570796326794897;
const R_TYPE _pi4_              =  0.7853981633974483;
const R_TYPE _pi8_              =  0.3926990816987242;
const R_TYPE _2pi_              =  6.283185307179586;
const R_TYPE _e_                =  2.718281828459045;

const H_PREC _PI_               =  3.141592653589793239L;
const H_PREC _PI2_              =  1.570796326794896619L;
const H_PREC _PI4_              =  0.7853981633974483096L;
const H_PREC _PI8_              =  0.3926990816987241548L;
const H_PREC _2PI_              =  6.283185307179586477L;
const H_PREC _E_                =  2.718281828459045235L;

const R_TYPE EPSILON            =  2.0e-015;                                                      /*  used as 'small' number    */


/* *** DECLARE GLOBAL VARIABLES *** (not to be used outside of this code) ***************************************************** */

C_TYPE     napa_title[21]       =  "variables and events";

int        napa_waypoint        =  0;

H_PREC     napa_abs_loop        =  0.0L;
H_PREC     napa_abs_time        =  0.0L;
H_PREC     napa_ref_time        =  0.0L;

I_TYPE     napa_random_seed     =  0LL;

long       napa_IO_count        =  0L;
IO_RECORD  napa_IO_record[63];

clock_t    napa_wall_clock      =  0;

int        napa_error_flag      =  false;

C_TYPE     napa_separator[256]  =  "\n\n";


/* *** DECLARE GLOBAL FUNCTION POINTERS *************************************************************************************** */

I_TYPE   (*napa_seed)(I_TYPE)   =  NULL;
I_TYPE   (*napa_rand)(void)     =  NULL;
I_TYPE   (*napa_root)(I_TYPE)   =  NULL;


/* *** NAPA FUNCTION PROTOTYPES *********************************************************************************************** */

void       napa_init(void);                                                           /*  see "/Simulate/NapaDos/Hdr/napa.hdr"  */
void       napa_close(void);                                                          /*  see "/Simulate/NapaDos/Hdr/napa.hdr"  */

void       napa_timer(long);
void       napa_exit(int);
void       napa_end(void);
void       napa_control_init(void);
void       napa_reset_variables(void);
void       napa_file_banner(void);

IO_COMMAND napa_IO_manager(IO_COMMAND, FILE**, char*, char*, char*);

I_TYPE     napa_default_seed(I_TYPE);                                                             /*  seed generator            */
I_TYPE     napa_default_rand(void);                                                               /*  random generator          */
I_TYPE     napa_default_root(I_TYPE);                                                             /*  seed randomizer           */


/* *** DECLARATIONS *********************************************************************************************************** */

/* (declare I/O's file handles)             */
FILE   *napa_fp_0      = (FILE*) NULL;
FILE   *napa_fp_1      = (FILE*) NULL;

/* (declare variables)                      */
R_TYPE  d_var_v1;
R_TYPE  d_var_v2;
I_TYPE  i_var_v3;
I_TYPE  i_var_e4;


/* *** INCLUDE NAPA USER'S HEADER FILE **************************************************************************************** */

#include  "/Simulate/NapaDos/Hdr/napa.hdr"


/* *** DEFAULT PSEUDO-RANDOM NUMBER GENERATOR ********************************************************************************* */

#if !defined(EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR)
# define NAPA_RAND  &napa_default_rand                                                             /* pointer to function       */
# define NAPA_SEED  &napa_default_seed                                                             /* pointer to function       */
# define NAPA_ROOT  &napa_default_root                                                             /* pointer to function       */
#endif


/* *** MAIN ******************************************************************************************************************* */

int main(void) {

  napa_waypoint = 2;

  /* (initialize control)                   */
  napa_control_init();
  napa_waypoint = 3;

  /* (initialize variables)                 */
  napa_random_seed = napa_seed(RANDOM_SEED);
  napa_reset_variables();

  /* (open I/O streams)                     */
  (void) IO_MANAGER(OPENWRITE, &napa_fp_0, "stderr", ".out", "output");
  (void) IO_MANAGER(OPENWRITE, &napa_fp_1, "stdout", ".out", "output");
  napa_waypoint = 4;

  /* (write file banner openings)           */
  napa_file_banner();

  /* (start main loop)                      */
  napa_waypoint = 5;

  do {

    napa_abs_time  = napa_abs_loop;

    /* block 1 (update variables)           */

    /* always */ {
      d_var_v1 = TIME;
      d_var_v2 = TIME;
      i_var_v3 = LOOP_INDEX/2LL;
      i_var_e4 = (I_TYPE)(ISTIME(9.5)||(90.0<TIME));
    }

    /* block 2 (update nodes) is empty      */

    /* block 3 (time domain output)         */

    /* always */ {
      if (false != (i_var_e4)) {
#if !defined(NO_TIME_OUTPUT)
        (void) fprintf(napa_fp_0,  "%.15Le", napa_abs_time);
#endif
        (void) fprintf(napa_fp_0,  "  % .12e % .12e % 11lld % 11lld\n", d_var_v1, d_var_v2, i_var_v3, i_var_e4);
      }
#if !defined(NO_TIME_OUTPUT)
      (void) fprintf(napa_fp_1,    "%.15Le", napa_abs_time);
#endif
      (void) fprintf(napa_fp_1,    "  % .12e % .12e % 11lld\n", d_var_v1, d_var_v2, i_var_v3);
    }

    napa_abs_loop++;

  } while (!TERMINATE);

  /* (main loop completed)                  */
  napa_waypoint = 6;

  /* (write file banner closings)           */
  napa_file_banner();

  /* (close I/O streams)                    */
  (void) IO_MANAGER(CLOSE, &napa_fp_0, "stderr", ".out", "output");
  (void) IO_MANAGER(CLOSE, &napa_fp_1, "stdout", ".out", "output");

  /* (end of simulation)                    */
  napa_waypoint = 7;
  napa_exit(EXIT_SUCCESS);

}


/* *** NAPA SIMULATOR FUNCTIONS *********************************************************************************************** */

void napa_control_init(void) {
  napa_wall_clock = clock();
  napa_seed = NAPA_SEED;
  napa_root = NAPA_ROOT;
  napa_rand = NAPA_RAND;
  (void) napa_init();
  if (0 != atexit(napa_end)) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (napa_end)\n");
    (void) fprintf(stderr,         " atexit() registering of 'napa_end()' did not succeed\n");
    napa_exit(EXIT_FAILURE);
  }
  if (0 != atexit(napa_close)) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (napa_close)\n");
    (void) fprintf(stderr,         " atexit() registering of 'napa_close()' did not succeed\n");
    napa_exit(EXIT_FAILURE);
  }
  return;
}

void napa_reset_variables(void) {
  d_var_v1 = TIME;
  d_var_v2 = TIME;
  i_var_v3 = -1LL;
  i_var_e4 = (I_TYPE)(ISTIME(9.5)||(90.0<TIME));
  (void) fprintf(stderr,   "\n");
  return;
}

void napa_file_banner(void) {
#if defined(STRICTLY_NO_BANNER)
  return;
#else
  if ((3 == napa_waypoint) || (4 == napa_waypoint)) {
    (void) fprintf(napa_fp_0,      "# (time domain output)\n");
  }
  if ((3 == napa_waypoint) || (4 == napa_waypoint) || (6 == napa_waypoint)) {
# if !defined(NO_TIME_OUTPUT)
    (void) fprintf(napa_fp_0,      "# absolute_time(s)     ");
# else
    (void) fprintf(napa_fp_0,      "#");
# endif
    (void) fprintf(napa_fp_0,      "                   v1");
    (void) fprintf(napa_fp_0,      "                   v2");
    (void) fprintf(napa_fp_0,      "          v3");
    (void) fprintf(napa_fp_0,      "          e4\n");
  }
  if ((3 == napa_waypoint) || (4 == napa_waypoint)) {
# if !defined(NO_BANNER)
    (void) fprintf(napa_fp_1,      "#  %s\n",                            TITLE);
    (void) fprintf(napa_fp_1,      "# (time domain output  )\n");
    (void) fprintf(napa_fp_1,      "# (compiler version    ) NAPA %s\n", NAPA_VERSION);
    (void) fprintf(napa_fp_1,      "# (source file         ) \"%s\"\n",  SOURCE);
    (void) fprintf(napa_fp_1,      "# (random seed         ) %lld\n",    RANDOM_SEED);
    (void) fprintf(napa_fp_1,      "# (output sampling rate) 1.00000  Hz\n");
#  if !defined(NO_TIME_OUTPUT)
    (void) fprintf(napa_fp_1,      "# (number of columns   ) 4\n#\n#\n#\n#\n#\n#\n");
#  else
    (void) fprintf(napa_fp_1,      "# (number of columns   ) 3\n#\n#\n#\n#\n#\n#\n");
#  endif
    (void) fprintf(napa_fp_1,      "# %s\n", CREATED);
# endif
  }
  if ((3 == napa_waypoint) || (4 == napa_waypoint) || (6 == napa_waypoint)) {
# if !defined(NO_TIME_OUTPUT)
    (void) fprintf(napa_fp_1,      "# absolute_time(s)     ");
# else
    (void) fprintf(napa_fp_1,      "#");
# endif
    (void) fprintf(napa_fp_1,      "                   v1");
    (void) fprintf(napa_fp_1,      "                   v2");
    (void) fprintf(napa_fp_1,      "          v3\n");
  }
  if  (6 == napa_waypoint) {
# if !defined(NO_BANNER)
    (void) fprintf(napa_fp_1,      "#\n");
    (void) fprintf(napa_fp_1,      "# (end of output file  )\n");
# endif
  }
  if ((5 == napa_waypoint) && (!TERMINATE)) {
    if (false != (i_var_e4)) {
      (void) fprintf(napa_fp_0,    "%s", SEPARATOR);
    }
    (void) fprintf(napa_fp_1,      "%s", SEPARATOR);
  }
  return;
#endif
}


/* *** STREAMLINED I/O RESOURCES MANAGER *** [Case Insensitive OS] ************************************************************ */
/* *** OPERATIONS:     OPENREAD, OPENWRITE, CLOSE, FREE                                                                         */

IO_COMMAND napa_IO_manager(IO_COMMAND command, FILE **fp, char *filename, char *suffix, char *tag) {
  static long id = 0L;
  size_t sz      = 255;
  char user[256] = {'\0'};
  char nam1[256] = {'\0'};
  char nam2[256] = {'\0'};
  char str[2]    = " ";
  long i, j, index, length;
  int  iflag, oflag;
  iflag = false;
  oflag = false;
  if (EOF == fflush(NULL)) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
    (void) fprintf(stderr,         " flushing data from buffers I/O was not successful\n");
    napa_exit(EXIT_FAILURE);
  }
  if (FREE != command) {
    length = (long) strlen(filename);
    if (0L == length) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream name is missing\n");
      napa_exit(EXIT_FAILURE);
    }
    length = 1L + MIN(length + ((long) strlen(suffix)), (long) sz);
    (void) snprintf(user, (size_t) length, "%s", filename);
    if ((char*) NULL == strstr(user, ".")) {
      if ((0 != strncmp(user, "stdin", sz)) && (0 != strncmp(user, "stdout", sz)) && (0 != strncmp(user, "stderr", sz))) {
        (void) strcat(user, suffix);
      }
    }
    for (i = 0L; i < length; i++) {
      nam1[i] = (char) tolower((int) user[i]);
    }
    index = -1L;
    for (i = 0L; i < napa_IO_count; i++) {
      for (j = 0L; j <= ((long) strlen(napa_IO_record[i].user)); j++) {
        nam2[j] = (char) tolower((int) ((napa_IO_record[i].user)[j]));
      }
      if (0 == strncmp(nam1, nam2, sz)) {
        index = i;
        if (0 != strncmp(user, napa_IO_record[index].user, sz)) {
          (void) fprintf(stderr, "\nNAPA Run Time Error:        (I/O manager for %s)\n\n", tag);
          (void) fprintf(stderr,   " Collision between I/O streams in a case-insensitive context:");
          (void) fprintf(stderr,   " <%s> and <%s>\n\n", user, napa_IO_record[index].user);
          napa_exit(EXIT_FAILURE);
        }
        break;
      }
    }
  }
  switch (command) {
  case OPENWRITE:
    if (0 == strncmp(user, "stdin", sz)) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Standard Input <%s> cannot be opened for write\n", user);
      napa_exit(EXIT_FAILURE);
    }
    str[0] = 'w';
    oflag  = true;
    break;
  case OPENREAD:
    if ((0 == strncmp(user, "stdout", sz)) || (0 == strncmp(user, "stderr", sz))) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Standard I/O stream <%s> cannot be opened for read\n", user);
      napa_exit(EXIT_FAILURE);
    }
    str[0] = 'r';
    iflag  = true;
    break;
  case CLOSE:
    if (-1L == index) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream <%s> cannot be closed as it has not been registered\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ((FILE*) NULL == napa_IO_record[index].f_ptr) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream <%s> is already closed\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ((0 != strncmp(user, "stdin", sz)) && (0 != strncmp(user, "stdout", sz)) && (0 != strncmp(user, "stderr", sz))) {
      if (EOF == fclose(napa_IO_record[index].f_ptr)) {
        (void) fprintf(stderr,   "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
        (void) fprintf(stderr,     " Unable to close I/O stream <%s>\n", user);
        napa_exit(EXIT_FAILURE);
      }
    }
    napa_IO_record[index].f_ptr = (FILE*) NULL;
    napa_IO_record[index].mode  = command;
#if (defined(DEBUG_MODE_IO) || defined(ALL_DEBUG))
    (void) fprintf(stderr,         "NAPA Debug Information:     (Close  I/O stream )");
    (void) fprintf(stderr,         " %18s for %-18s <- % .0Lf\n", user, tag, napa_abs_loop);
#endif
    *fp = (FILE*) NULL;
    return command;
  case FREE:
    if (0L >= napa_IO_count) {
      return command;
    }
    j = 0L;
    for (i = 0L; i < napa_IO_count; i++) {
      if (UNKNOWN == napa_IO_record[i].mode) {
        continue;
      }
      if (CLOSE == napa_IO_record[i].mode) {
#if ((defined(DEBUG_MODE_IO) || defined(ALL_DEBUG)) && defined(VERBOSE))
        (void) fprintf(stderr,     "NAPA Debug Information:     (Purge  I/O stream )");
        (void) fprintf(stderr,     " I/O record #%-2ld is freed\n", napa_IO_record[i].id);
#endif
        free(napa_IO_record[i].user);
        napa_IO_record[i].user  = (char*) NULL;
      } else {
        (void) strcpy(napa_IO_record[j].user, napa_IO_record[i].user);
        napa_IO_record[j].f_ptr = napa_IO_record[i].f_ptr;
        napa_IO_record[j].id    = napa_IO_record[i].id;
        napa_IO_record[j].mode  = napa_IO_record[i].mode;
        napa_IO_record[j].iflag = napa_IO_record[i].iflag;
        napa_IO_record[j].oflag = napa_IO_record[i].oflag;
        j++;
      }
    }
    napa_IO_count = j;
#if ((defined(DEBUG_MODE_IO) || defined(ALL_DEBUG)) && defined(VERBOSE))
    if (0L < napa_IO_count) {
      (void) fprintf(stderr,       "NAPA Debug Information:     (Purge  I/O stream )");
      (void) fprintf(stderr,       " %ld I/O records still allocated\n", napa_IO_count);
    }
#endif
    return command;
  case OPENREAD_BINARY:
  case REWIND:
  case OPENAPPEND:
  case OPENAPPEND_BINARY:
  case OPENWRITE_BINARY:
  case REWRITE:
  case QUERY:
  case DEBUG:
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
    (void) fprintf(stderr,         " I/O stream management command <%d> not implemented in this streamlined manager\n", command);
    napa_exit(EXIT_FAILURE);
  default:
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
    (void) fprintf(stderr,         " Unknown I/O stream management command <%d>\n", command);
    napa_exit(EXIT_FAILURE);
  }
  if (-1L == index) {
    napa_IO_record[napa_IO_count].user = (char*) calloc((size_t) (1L+length), sizeof(char));
    if ((char*) NULL == napa_IO_record[napa_IO_count].user) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Dynamic memory allocation error while recording I/O stream <%s>\n", user);
      napa_exit(EXIT_FAILURE);
    }
  } else {
    if ((FILE*) NULL != napa_IO_record[index].f_ptr) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream <%s> cannot be opened twice\n", user);
      napa_exit(EXIT_FAILURE);
    }
  }
  if        (0 == strncmp(user, "stdin",  sz)) {
    *fp = stdin;
  } else if (0 == strncmp(user, "stdout", sz)) {
    *fp = stdout;
  } else if (0 == strncmp(user, "stderr", sz)) {
    *fp = stderr;
  } else {
    *fp = fopen(user, str);
    if ((FILE*) NULL == *fp) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Unable to open I/O file <%s>\n", user);
      napa_exit(EXIT_FAILURE);
    }
  }
  if (-1L == index) {
    (void) strcpy(napa_IO_record[napa_IO_count].user, user);
    napa_IO_record[napa_IO_count].f_ptr = *fp;
    napa_IO_record[napa_IO_count].id    = id;
    napa_IO_record[napa_IO_count].mode  = command;
    napa_IO_record[napa_IO_count].iflag = iflag || napa_IO_record[napa_IO_count].iflag;
    napa_IO_record[napa_IO_count].oflag = oflag || napa_IO_record[napa_IO_count].oflag;
#if ((defined(DEBUG_MODE_IO) || defined(ALL_DEBUG)) && defined(VERBOSE))
    (void) fprintf(stderr,         "NAPA Debug Information:     (Create I/O stream ) <record[%4ld]>\n", id);
#endif
    id++;
    napa_IO_count++;
    if (63L <= napa_IO_count) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error:        (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Internal arrays overflow (max = 63 I/O) while registering I/O stream <%s>\n", user);
      napa_exit(EXIT_FAILURE);
    }
  } else {
    napa_IO_record[index].f_ptr = *fp;
    napa_IO_record[index].mode  = command;
    napa_IO_record[index].iflag = iflag || napa_IO_record[index].iflag;
    napa_IO_record[index].oflag = oflag || napa_IO_record[index].oflag;
  }
#if (defined(DEBUG_MODE_IO) || defined(ALL_DEBUG))
  (void) fprintf(stderr,           "NAPA Debug Information:     (Open   I/O stream )");
  (void) fprintf(stderr,           " %18s for %-18s <- % .0Lf\n", user, tag, napa_abs_loop);
#endif
  return command;
}


/* *** SEED RANDOMIZER (MATSUMOTO & NISHIMURA IMPROVED LCG) ******************************************************************* */

#if !defined(EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR)

I_TYPE napa_default_root(I_TYPE seed) {
  unsigned long ulrnd;
  static unsigned long j = 1UL;
  ulrnd = ((unsigned long) seed) & 0XFFFFFFFFUL;
  ulrnd = (1812433253UL * (ulrnd^(ulrnd >> 30))) + j;
  j++;
  return (I_TYPE) (ulrnd & 0XFFFFFFFFUL);
}

#endif


/* *** PSEUDO-RANDOM NUMBER GENERATOR (MERSENNE TWISTER MT19937-64) *********************************************************** */
/* *** Source: Takuji Nishimura and Makoto Matsumoto, version 2004/9/29                                                    **** */
/* *** Modified to fit NAPA  V4.02                                                                                         **** */

#if !defined(EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR)

unsigned long long napa_random_mta[312];
int                napa_random_mti = 0;

I_TYPE napa_default_seed(I_TYPE seed) {
  time_t t;
  if (0LL == seed) {
    t = time(NULL);
    seed = ((I_TYPE) t) / 2LL;
  } else {
    seed = (0LL < seed) ? seed : -seed;
  }
  napa_random_mta[0] = (unsigned long long) napa_root(seed);
  for (napa_random_mti = 1; napa_random_mti < 312; napa_random_mti++) {
    napa_random_mta[napa_random_mti]  = napa_random_mta[napa_random_mti-1];
    napa_random_mta[napa_random_mti] ^= napa_random_mta[napa_random_mti-1] >> 62;
    napa_random_mta[napa_random_mti] *= 6364136223846793005ULL;
    napa_random_mta[napa_random_mti] += napa_random_mti;
  }
  return seed;
}

I_TYPE napa_default_rand(void) {
  int i;
  unsigned long long x;
  static unsigned long long mag01[2] = {0ULL, 0XB5026F5AA96619E9ULL};
  if (312 <= napa_random_mti) {
    for (i = 0; i < 156; i++) {
      x = (napa_random_mta[  i] & 0XFFFFFFFF80000000ULL) | (napa_random_mta[i+1] & 0X7FFFFFFFULL);
      napa_random_mta[i] = napa_random_mta[i+156] ^ (x>>1) ^ mag01[(int) (x&1ULL)];
    }
    for (i = 156; i < 311; i++) {
      x = (napa_random_mta[  i] & 0XFFFFFFFF80000000ULL) | (napa_random_mta[i+1] & 0X7FFFFFFFULL);
      napa_random_mta[i] = napa_random_mta[i-156] ^ (x>>1) ^ mag01[(int) (x&1ULL)];
    }
    x =   (napa_random_mta[311] & 0XFFFFFFFF80000000ULL) | (napa_random_mta[  0] & 0X7FFFFFFFULL);
    napa_random_mta[311] = napa_random_mta[  155] ^ (x>>1) ^ mag01[(int) (x&1ULL)];
    napa_random_mti = 0;
  }
  x  = napa_random_mta[napa_random_mti++];
  x ^= (x >> 29) & 0X5555555555555555ULL;
  x ^= (x << 17) & 0X71D67FFFEDA60000ULL;
  x ^= (x << 37) & 0XFFF7EEE000000000ULL;
  x ^= (x >> 43);
  return (I_TYPE) (x >> 1);
}

#endif


/* *** TIMER FUNCTION (seconds) *********************************************************************************************** */

void napa_timer(long cnt) {
  time_t time_start, time_stop;
  if (0L < cnt) {
    time_start = time(NULL);
    do {
      time_stop = time(NULL);
    } while (((long) (time_stop - time_start)) <= cnt);
  }
  return;
}


/* *** EXIT FUNCTIONS ********************************************************************************************************* */

void napa_end(void) {
  if (false == napa_error_flag) {
    (void) napa_IO_manager(FREE, (FILE**) NULL, (char*) NULL, (char*) NULL, "end");
    (void) fprintf(stderr,       "\n ****  Normal Termination %25s ****\n", " ");
  }
#if defined(VERBOSE) && defined(NAPA_EXIT_STATUS)
  (void) fprintf(stderr,           " ****  NAPA Exit Status: %10s < %d > %9s ****\n\n", " ", napa_waypoint, " ");
#endif
  return;
}

void napa_exit(int exit_code) {
  if (EOF == fflush(NULL)) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error:        (exit)");
    (void) fprintf(stderr,         " flushing data from I/O buffers was not successful\n\n");
    exit_code = EXIT_FAILURE;
  }
  if (EXIT_FAILURE == exit_code) {
    napa_error_flag = true;
    (void) fprintf(stderr,     "\n\n ****  ERROR detected ");
    switch (napa_waypoint) {
      case 1:
      case 2: (void) fprintf(stderr, "before the initialization of the simulation."                ); break;
      case 3: (void) fprintf(stderr, "during the 1st part of the initialization of the simulation."); break;
      case 4: (void) fprintf(stderr, "during the 2nd part of the initialization of the simulation."); break;
      case 5: (void) fprintf(stderr, "at loop #%.0Lf during the simulation.",         napa_abs_loop); break;
      case 6: (void) fprintf(stderr, "at loop #%.0Lf when simulation is closing.",    napa_abs_loop); break;
      case 7: (void) fprintf(stderr, "during the execution of the NAPA exit code."                 ); break;
    }
    (void) fprintf(stderr,     "\n\n");
#ifdef NAPA_EXIT_STATUS
    exit(napa_waypoint);
#else
    exit(EXIT_FAILURE);
#endif
  } else {
    exit(EXIT_SUCCESS);
  }
}


/* *** FILE BUILT IN 15.0 ms (WALL CLOCK) FOR Yves Leduc ********************************************************************** */

