
/* *** CREATED BY NAPA X3.05e [Win64] ***** Mon Apr 30 09:45:02 2018 ********************************************************** */

/* *** Ad Hoc Cycle-Based ANSI-C Simulator Compiled for Yves Leduc                                                          *** */

/* *** Author and support:  Yves Leduc                                                                                      *** */
/* *** Email:  Yves.Leduc@borogoves.eu                                                                                      *** */

/* ***                                                                                                                      *** */
/* ***                                                                                                                      *** */
/* *** RAM and ROM                                                                                                          *** */
/* ***                                                                                                                      *** */
/* ***                                                                                                                      *** */


/* **************************************************************************************************************************** */
/* ***  This file has been produced by a BETA RELEASE of version V3.05                                                      *** */
/* ***  Use this version for evaluation only.                                                                               *** */
/* ***  Switch to next standard release as soon as possible.                                                                *** */
/* **************************************************************************************************************************** */


/* This ANSI-C [C11] code has been produced by the NAPA compiler from these 3 netlist files:                                    */
/*      -> "ex16.tmp"                (main)                                                                                     */
/*  2x  -> "/simulate/napados/net/counter/modcnt.net"                                                                           */
/*      -> "/simulate/napados/net/noise/rclock.net"                                                                             */

/* These libraries have been referenced in the NAPA compiler line command:                                                      */
/*      -> Generic headers        : "/Simulate/NapaDos/Hdr"                                                                     */
/*      -> Generic cells          : "/Simulate/NapaDos/Net"                                                                     */
/*      -> Generic generators     : "/Simulate/NapaDos/Gen"                                                                     */

/* Main loop of the simulator is divided in 3 blocks containing code                                                            */
/* respectively for variable updates, node updates and time domain output.                                                      */

/* Simulator built for Windows OS, where file names are not case-sensitive.                                                     */

/* (char) coded with              :    1 byte   (C_TYPE)                                                                        */
/* (short int) coded with         :    2 bytes                                                                                  */
/* (int) coded with               :    4 bytes                                                                                  */
/* (long int) coded with          :    4 bytes  (P_TYPE)                                                                        */
/* (long long) coded with         :    8 bytes  (I_TYPE)                                                                        */
/* (float) coded with             :    4 bytes  (L_PREC)                                                                        */
/* (double float) coded with      :    8 bytes  (R_TYPE)                                                                        */
/* (long double float) coded with :   16 bytes  (H_PREC)                                                                        */
/* (size_t) coded with            :    8 bytes                                                                                  */
/* (void*) coded with             :    8 bytes                                                                                  */

/* Resolution of a double float   :   15 digits (R_TYPE)                                                                        */

/* Number of user's nodes         :   11                                                                                        */
/* Number of user's variables     :    3                                                                                        */
/* Number of user's declarations  :    9                                                                                        */
/* Number of cell instantiations  :    3                                                                                        */

/* Simulation rate                :    1.00000 MHz                                                                              */
/* Sampling frequency             :    1.00000 MHz                                                                              */

/* A dump file may be output      : "ex16.dmp"                                                                                  */

/* Internal pseudo-random generator uses a seed chosen randomly at COMPILATION time.                                            */
/* Use the RANDOM_SEED value defined below to restart a simulation in the same conditions.                                      */

/* Please report bugs or suggestions to 'Yves.Leduc@borogoves.eu'                                                               */


/* *** INCLUDE ANSI-C STANDARD HEADER FILES *********************************************************************************** */

#include <ctype.h>
#include <limits.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>


/* *** MACRO CONSTANTS AND VARIABLES AVAILABLE TO USER ************************************************************************ */

#define  PLATFORM            "Win64"
#define  NAPA_VERSION        "X3.05e for " PLATFORM

#define  USER                "Yves Leduc"
#define  CREATED             "Mon Apr 30 09:45:02 2018 by " USER
#define  NAPA_JOB_ID         "YL_20180430_094502"                                                 /*  unique tag                */

#define  ORIGIN              "ex16"
#define  SOURCE              "ex16.tmp"                                                           /*  NAPA main file            */
#define  CODE                "ex16.c"                                                             /*  corresponding C file      */

#define  HEADERS_LIB         "/Simulate/NapaDos/Hdr"
#define  CELLS_LIB           "/Simulate/NapaDos/Net"
#define  GENERATORS_LIB      "/Simulate/NapaDos/Gen"

#define  TITLE               (napa_title)
#define  SHORT_TITLE         (napa_title)

#define  TERMINATE           (LOOP_INDEX>100)

#define  NUM_OF_TIME_OUTPUTS 1L

#define  NUM_OF_SEGMENTS     1L
#define  SEGMENT             0L

#define  RANDOM_SEED         762537151LL                                                          /*  unique random seed        */
#define  ANTITHETIC          FALSE

#define  TIME                ((R_TYPE) napa_abs_time)
#define  REF_TIME            ((R_TYPE) napa_abs_time)
#define  ABS_TIME            ((R_TYPE) napa_abs_time)
#define  REL_TIME            ((R_TYPE) napa_abs_time)

#define  LOOP_INDEX          ((I_TYPE) napa_abs_loop)
#define  ABS_LOOP_INDEX      ((I_TYPE) napa_abs_loop)
#define  REL_LOOP_INDEX      ((I_TYPE) napa_abs_loop)

#define  SIM_RATE            1.000000000000000e+006
#define  FS                  1.000000000000000e+006
#define  FSL                 1.000000000000000e+006
#define  STL                 0LL

#define  NUM_INITIAL         0LL

#define  PERIODIC            TRUE

#define  STAGE               (napa_stage)

#define  SEPARATOR           (napa_separator)

#define  ERROR_FLAG          (napa_error_flag)
#define  ASSERT_FLAG         FALSE
#define  DUMP_FLAG           (napa_dump_flag)
#define  WALL_CLOCK          (((R_TYPE)(clock()-napa_wall_clock))/((R_TYPE)CLOCKS_PER_SEC))

#define  I_FORMAT            " % 11lld"                                                           /*  format by default         */
#define  X_FORMAT            " %#018llX"                                                          /*  format by default         */
#define  R_FORMAT            " % .12e"                                                            /*  format by default         */
#define  S_FORMAT            " %12s"                                                              /*  format by default         */

#define  ANALOG_INI          0.0
#define  DIGITAL_INI         0LL

#define  FALSE               0
#define  TRUE                1
#define  NO                  0
#define  YES                 1

#define  STOP                0LL
#define  START               1LL

#define  BIG_ENDIAN          0
#define  LITTLE_ENDIAN       1

#define  CPU_ARCHITECTURE    LITTLE_ENDIAN


/* *** MACRO FUNCTIONS MADE AVAILABLE TO USER ********************************************************************************* */

#define  ABS(x)              ((0.0<(x))?(x):-(x))
#define  SIGN(x)             ((0.0<(x))-(0.0>(x)))                                 /* returns -1, 0 or 1                        */
#define  MIN(x,y)            (((x)<(y))?(x):(y))
#define  MAX(x,y)            (((x)>(y))?(x):(y))
#define  CLIP(x,l,h)         MIN(MAX((x),(l)),(h))

#define  ISINSIDE(x,l,h)     (((x)>=(l))&&((x)<=(h)))                              /* inside the interval                       */
#define  ISOUTSIDE(x,l,h)    (((x)<(l))||((x)>(h)))                                /* strictly outside the interval             */
#define  ISEQUAL(x,y)        (ABS((x)-(y))<=(EPSILON*(ABS(x)+ABS(y))))             /* relative comparison with a treshold       */
#define  ISNOTEQUAL(x,y)     (ABS((x)-(y))> (EPSILON*(ABS(x)+ABS(y))))             /* relative comparison with a treshold       */
#define  ISTIME(t)           (((FSL*((t)-TIME))<0.5)&&((FSL*(TIME-(t)))<=0.5))     /* time inside the current sampling interval */
#define  ISSMALL(x)          (EPSILON>=ABS(x))
#define  ISNOTSMALL(x)       (EPSILON< ABS(x))
#define  ISEVEN(x)           (0LL==(D2I(x)%2LL))
#define  ISODD(x)            (0LL!=(D2I(x)%2LL))
#define  ISINTEGER(x)        ISEQUAL(x,D2I(x))
#define  ISPOWEROF2(n)       (!(((I_TYPE)(n))&(((I_TYPE)(n))-1LL))&&((I_TYPE)(n)))

#define  POWEROF2(n)         ((0LL<((I_TYPE)(n)))?(1LL<<((I_TYPE)(n))):1LL)

#define  MODULO(x,y)         ((x)-((y)*floor(((R_TYPE)(x))/((R_TYPE)(y)))))
#define  SIN(x)              ((R_TYPE)sinl((H_PREC)(x)))                           /* keep precision when x is high             */
#define  COS(x)              ((R_TYPE)cosl((H_PREC)(x)))                           /* keep precision when x is high             */
#define  SQRT(x)             sqrt(MAX(0.0,(x)))                                    /* avoid negative values                     */
#define  LOG(x)              log(MAX(EPSILON,(x)))                                 /* avoid values below or equal to zero       */
#define  POW(x,y)            pow(MAX(0.0,(x)),(y))                                 /* avoid negative values                     */
#define  ROOT(x,y)           pow(MAX(0.0,(x)),1.0/((R_TYPE)(y)))                   /* avoid negative values                     */
#define  LOG10(x)            log10(MAX(EPSILON,(x)))                               /* avoid values below or equal to zero       */
#define  POW10(y)            pow(10.0,(y))

#define  D2I(x)              ((0.0<(x))?(I_TYPE)((x)+0.5):(I_TYPE)((x)-0.5))
#define  I2D(n)              ((R_TYPE)(n))
#define  DB2LIN(x,r)         ((r)*POW10(0.05*(x)))
#define  LIN2DB(x,r)         (20.0*LOG10(((R_TYPE)(x))/((R_TYPE)(r))))
#define  DB2POW(x,r)         ((r)*POW10(0.10*(x)))
#define  POW2DB(x,r)         (10.0*LOG10(((R_TYPE)(x))/((R_TYPE)(r))))
#define  RAD2DEG(x)          (5.729577951308232e+001*((R_TYPE)(x)))
#define  DEG2RAD(x)          (1.745329251994330e-002*((R_TYPE)(x)))

#define  LENGTH(s)           ((I_TYPE)strlen(s))

#define  LINDOMAIN(c,b,e)    ((b)+((c)*((e)-(b))))
#define  LOGDOMAIN(c,b,e)    ((b)*POW10((c)*LOG10(((R_TYPE)(e))/((R_TYPE)(b)))))
#define  LINSWEEP(c,b,e,n)   LINDOMAIN((((R_TYPE)(c))/((R_TYPE)((n)-1L))),(b),(e))
#define  LOGSWEEP(c,b,e,n)   LOGDOMAIN((((R_TYPE)(c))/((R_TYPE)((n)-1L))),(b),(e))

#define  RAND_01()           (1.11022302462515666e-16*( (R_TYPE)(napa_rand()>>10)))               /* output in interval [0,1]   */
#define  RAND_01_X()         (2.22044604925031332e-16*(((R_TYPE)(napa_rand()>>11))+0.5))          /* output in interval ]0,1[   */

#define  FSS(n)              1.000000000000000e+006                                               /* constant                   */
#define  STS(n)              0LL                                                                  /* constant                   */
#define  NIS(n)              0LL                                                                  /* constant                   */
#define  PS(n)               TRUE                                                                 /* constant                   */

#define  IO_MANAGER(c,f,n,s,t)    napa_IO_manager(c,f,n,s,t)
#define  SEGMENT_CONDITION(n)     TRUE                                                            /* constant                   */
#define  TIMER(n)                 napa_timer(n)

#define  PING(fun)                                                                                /* empty function             */

#define  NOT_REGISTERED(fun)                                                                                /* empty function   */


/* *** OPTIONAL NAPA DIRECTIVES TO CONFIGURE FURTHER THIS SIMULATION ********************************************************** */

/*  directive TIME_OFFSET    <R_TYPE Number>                                                                                    */
/*  directive JITTER         <R_TYPE Formula>                                                                                   */
/*  directive STRICTLY_NO_BANNER                                                                                                */
/*  directive NO_BANNER                                                                                                         */
/*  directive NO_TIME_OUTPUT                                                                                                    */
/*  directive EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR  <File Pathname>                                                          */

/*  debug     DUMP                                                                                                              */
/*  debug     IO                                                                                                                */

/*  directive VERBOSE                                                                                                           */

/*  [Header files of the library may be configured with specific directives]                                                    */



/* *** DECLARE NAPA TYPES ***************************************************************************************************** */

typedef   long long I_TYPE;
typedef      double R_TYPE;
typedef        char C_TYPE;
typedef        long P_TYPE;

typedef       float L_PREC;
typedef long double H_PREC;

typedef enum {
  UNKNOWN,              /*   0  */
  CLOSE,                /*   1  */
  OPENREAD,             /*   2  */
  OPENREAD_BINARY,      /*   3  */
  OPENWRITE,            /*   4  */
  OPENWRITE_BINARY,     /*   5  */
  OPENAPPEND,           /*   6  */
  OPENAPPEND_BINARY,    /*   7  */
  QUERY,                /*   8  */
  REWIND,               /*   9  */
  REWRITE,              /*  10  */
  ALLOCATE,             /*  11  */
  FREE,                 /*  12  */
  DELETE,               /*  13  */
  RESET,                /*  14  */
  DEBUG                 /*  15  */
} IO_COMMAND;

typedef struct {
  C_TYPE     name[512];
  C_TYPE   **s_ptr;
  I_TYPE   **i_ptr;
  R_TYPE   **d_ptr;
  C_TYPE   **c_ptr;
  long       length;
  long       nrow;
  long       ncol;
} DATA_RECORD;

typedef struct {
  I_TYPE    *data;
  I_TYPE     length;
  I_TYPE     address;
  I_TYPE     rw;
  H_PREC     last;
  int       *flag;
} RAM2_I_RECORD;

typedef struct {
  I_TYPE    *data;
  I_TYPE     length;
  I_TYPE     address;
} ROM2_I_RECORD;

typedef struct {
  FILE      *f_ptr;
  C_TYPE    *user;
  long       id;
  IO_COMMAND mode;
  int        iflag;
  int        oflag;
} IO_RECORD;


/* *** DECLARE GLOBAL CONSTANTS *********************************************************************************************** */

const R_TYPE _pi_              =  3.141592653589793;
const R_TYPE _pi2_             =  1.570796326794897;
const R_TYPE _pi4_             =  0.7853981633974483;
const R_TYPE _pi8_             =  0.3926990816987241;
const R_TYPE _2pi_             =  6.283185307179586;
const R_TYPE _e_               =  2.718281828459045;

const H_PREC _PI_              =  3.141592653589793239L;
const H_PREC _PI2_             =  1.570796326794896619L;
const H_PREC _PI4_             =  0.7853981633974483096L;
const H_PREC _PI8_             =  0.3926990816987241548L;
const H_PREC _2PI_             =  6.283185307179586477L;
const H_PREC _E_               =  2.718281828459045235L;

const R_TYPE EPSILON           =  2.0e-015;                                                       /*  used as 'small' number    */


/* *** DECLARE GLOBAL VARIABLES *********************************************************************************************** */

C_TYPE     napa_title[]        =  "RAM and ROM";

int        napa_stage          =  0;

H_PREC     napa_abs_loop       =  0.0L;
H_PREC     napa_abs_time       =  0.0L;
H_PREC     napa_ref_time       =  0.0L;

I_TYPE     napa_random_seed    =  0LL;

long       napa_IO_count       =  0L;
IO_RECORD  napa_IO_record[127];

clock_t    napa_wall_clock     =  0;

int        napa_dump_flag      =  FALSE;
int        napa_error_flag     =  FALSE;

C_TYPE     napa_separator[256] =  "\n\n";


/* *** DECLARE GLOBAL FUNCTION POINTERS *************************************************************************************** */

I_TYPE   (*napa_seed)(I_TYPE)  =  NULL;
I_TYPE   (*napa_rand)(void)    =  NULL;
I_TYPE   (*napa_root)(I_TYPE)  =  NULL;


/* *** NAPA FUNCTION PROTOTYPES *********************************************************************************************** */

int        main(void);

void       napa_init(void);                                                       /*  see "/Simulate/NapaDos/Hdr/napatool.hdr"  */
void       napa_close(void);                                                      /*  see "/Simulate/NapaDos/Hdr/napatool.hdr"  */

void       napa_timer(long);
void       napa_exit(long);
void       napa_end(void);
void       napa_control_init(void);
void       napa_array_setup(IO_COMMAND);
void       napa_reset_variables(void);
void       napa_reset_nodes(void);
void       napa_file_banner(void);
void       napa_dump_states(void);

IO_COMMAND napa_IO_manager(IO_COMMAND, FILE**, char*, char*, char*);

I_TYPE     napa_default_seed(I_TYPE);                                                             /*  seed generator            */
I_TYPE     napa_default_rand(void);                                                               /*  random generator          */
I_TYPE     napa_default_root(I_TYPE);                                                             /*  seed randomizer           */


/* *** USER'S FUNCTION COMPILATION DIRECTIVES ********************************************************************************* */

#define COMPILE_rand_bernoulli
#define COMPILE_randomize_array


/* *** DECLARATIONS *********************************************************************************************************** */

/* (declare I/O's file handles)             */
FILE   *napa_fp_0      = (FILE*) NULL;

/* (declare array file pointers)            */
FILE   *napa_fp_init_2 = (FILE*) NULL;

/* (declare dump file pointer)              */
FILE   *napa_fp_dump   = (FILE*) NULL;

/* (declare variables)                      */
I_TYPE  i_var_RAM_SIZE;
C_TYPE  s_var_ram_file[9];
I_TYPE  init_cnt1__s2;
I_TYPE  init_cnt2__s2;
I_TYPE  i_var_ev1;

/* (declare nodes)                          */
I_TYPE  i_node_a1;
I_TYPE  i_node_a2;
I_TYPE  i_node_rwb;
I_TYPE  i_node_b;
I_TYPE  i_node_r;
I_TYPE  i_node_d1;
I_TYPE  i_node_d2;
I_TYPE  i_node_One;
I_TYPE  i_node_One_dc;
I_TYPE  i_node_cnt1__s1;
I_TYPE  i_node_cnt2__s1;
I_TYPE  i_node_cnt2__s2;
I_TYPE  i_node_cnt1__s2;

/* (declare arrays)                         */
RAM2_I_RECORD i_array_myram1;
ROM2_I_RECORD i_array_myrom3;


/* *** INCLUDE NAPA USER'S HEADER FILES *************************************************************************************** */

#include  "/Simulate/NapaDos/Hdr/napatool.hdr"
#include  "/Simulate/NapaDos/Hdr/Function/random.hdr"


/* *** DEFAULT PSEUDO-RANDOM NUMBER GENERATOR ********************************************************************************* */

#if !defined(EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR)
# define NAPA_RAND  &napa_default_rand
# define NAPA_SEED  &napa_default_seed
# define NAPA_ROOT  &napa_default_root
#endif


/* *** MAIN ******************************************************************************************************************* */

int main(void) {

  /* (initialize control)                   */
  napa_stage = 1;
  napa_control_init();

  /* (initialize variables)                 */
  napa_random_seed = napa_seed(RANDOM_SEED);
  napa_reset_variables();

  /* (open I/O stream)                      */
  (void) IO_MANAGER(OPENWRITE, &napa_fp_0, "stdout", ".out", "output");
  (void) IO_MANAGER(OPENWRITE, &napa_fp_dump, "ex16.dmp", ".dmp", "dump");

  /* (initialize nodes)                     */
  napa_reset_nodes();
  napa_stage = 2;

  /* (initialize arrays)                    */
  napa_array_setup(ALLOCATE);

  /* (write file banner opening)            */
  napa_file_banner();

  /* (start main loop)                      */
  napa_stage = 3;

  do {

    napa_abs_time  = napa_abs_loop * 1.000000000000000e-006L;

    /* block 1 (update variables)           */

    /* always */ {
      i_var_ev1 = (I_TYPE)((10==LOOP_INDEX)||(100==LOOP_INDEX));
    }

    /* block 2 (update nodes)               */

    /* always */ {
      i_node_a1 = i_node_cnt1__s2;
      i_node_a2 = i_node_cnt2__s2;
      i_node_rwb = ((I_TYPE) rand_bernoulli(0.50));
      if ((0LL > i_node_a2) || (i_node_a2 >= i_array_myrom3.length)) {
        (void) fprintf(stderr, "\nNAPA Run Time Error: (rom)\n");
        (void) fprintf(stderr,   " -> at line  56 of main netlist\n");
        (void) fprintf(stderr, "\n unexpected value <%lld> for address of ROM <myrom3[%lld]>\n", i_node_a2, i_array_myrom3.length);
        napa_exit(EXIT_FAILURE);
      }
      i_node_b = i_array_myrom3.data[i_node_a2];
      i_array_myrom3.address = i_node_a2;
      if ((0LL > i_node_b) || (i_node_b >= i_array_myrom3.length)) {
        (void) fprintf(stderr, "\nNAPA Run Time Error: (rom)\n");
        (void) fprintf(stderr,   " -> at line  57 of main netlist\n");
        (void) fprintf(stderr, "\n unexpected value <%lld> for address of ROM <myrom3[%lld]>\n", i_node_b, i_array_myrom3.length);
        napa_exit(EXIT_FAILURE);
      }
      i_node_r = i_array_myrom3.data[i_node_b];
      if (i_node_b == i_array_myrom3.address) {
        (void) fprintf(stderr, "\nNAPA Run Time Error: (rom)\n");
        (void) fprintf(stderr,   " -> at line  57 of main netlist\n");
        (void) fprintf(stderr, "\n access collision at address <%lld> of dual port ROM <myrom3[%lld]>\n", i_node_b, i_array_myrom3.length);
        napa_exit(EXIT_FAILURE);
      }
      if ((i_node_a1 < 0LL) || (i_node_a1 >= i_array_myram1.length)) {
        (void) fprintf(stderr, "\nNAPA Run Time Error: (ram)\n");
        (void) fprintf(stderr,   " -> at line  54 of main netlist\n");
        (void) fprintf(stderr, "\n unexpected value <%lld> for address of RAM <myram1[%lld]>\n", i_node_a1, i_array_myram1.length);
        napa_exit(EXIT_FAILURE);
      }
      if (0LL == i_node_rwb) {
        i_array_myram1.data[i_node_a1] = i_node_r;
        i_array_myram1.flag[i_node_a1] = TRUE;
        i_node_d1 = i_node_r;
      } else {
        if (FALSE == i_array_myram1.flag[i_node_a1]) {
          i_array_myram1.last = napa_abs_loop;
        }
        i_node_d1 = i_array_myram1.data[i_node_a1];
      }
      i_array_myram1.address = i_node_a1;
      i_array_myram1.rw      = i_node_rwb;
      if ((i_node_b < 0LL) || (i_node_b >= i_array_myram1.length)) {
        (void) fprintf(stderr, "\nNAPA Run Time Error: (ram)\n");
        (void) fprintf(stderr,   " -> at line  55 of main netlist\n");
        (void) fprintf(stderr, "\n unexpected value <%lld> for address of RAM <myram1[%lld]>\n", i_node_b, i_array_myram1.length);
        napa_exit(EXIT_FAILURE);
      }
      if (0LL == i_node_rwb) {
        i_array_myram1.data[i_node_b] = i_node_r;
        i_array_myram1.flag[i_node_b] = TRUE;
        i_node_d2 = i_node_r;
      } else {
        if (FALSE == i_array_myram1.flag[i_node_b]) {
          i_array_myram1.last = napa_abs_loop;
        }
        i_node_d2 = i_array_myram1.data[i_node_b];
      }
      if (i_node_b == i_array_myram1.address) {
        (void) fprintf(stderr, "\nNAPA Run Time Error: (ram)\n");
        (void) fprintf(stderr,   " -> at line  55 of main netlist\n");
        (void) fprintf(stderr, "\n access collision at address <%lld> of dual port RAM <myram1[%lld]>\n", i_node_b, i_array_myram1.length);
        napa_exit(EXIT_FAILURE);
      }
      if (i_node_rwb != i_array_myram1.rw) {
        (void) fprintf(stderr, "\nNAPA Run Time Error: (ram)\n");
        (void) fprintf(stderr,   " -> at line  55 of main netlist\n");
        (void) fprintf(stderr, "\n uncompatible R/W command for dual port RAM <myram1[%lld]>\n", i_array_myram1.length);
        napa_exit(EXIT_FAILURE);
      }
      i_node_One = i_node_One_dc;
      i_node_cnt1__s1 = (i_node_a1) + (i_node_One);
      i_node_cnt2__s1 = (i_node_a2) + (i_node_One);
      i_node_cnt2__s2 = (i_node_cnt2__s1) % (8LL);
      if (0LL == i_var_RAM_SIZE) {
        (void) fprintf(stderr, "\nNAPA Run Time Error: (mod)\n");
        (void) fprintf(stderr,   " -> at line  31 of main netlist\n");
        (void) fprintf(stderr,   " -> at line  30 of \"/simulate/napados/net/counter/modcnt.net\"\n");
        (void) fprintf(stderr, "\n division by zero\n");
        napa_exit(EXIT_FAILURE);
      }
      i_node_cnt1__s2 = (i_node_cnt1__s1) % (i_var_RAM_SIZE);
    }

    /* block 3 (time domain output)         */

    /* always */ {
#if !defined(NO_TIME_OUTPUT)
      (void) fprintf(napa_fp_0,    "%.15Le", napa_abs_time);
#endif
      (void) fprintf(napa_fp_0,    "  % 11lld % 11lld % 11lld % 11lld % 11lld % 11lld\n",
        i_node_a1, i_node_a2, i_node_rwb, i_node_r, i_node_d1, i_node_d2);
    }

    /* always */ {

      /* (dump triggering)                  */
      if (FALSE != (i_var_ev1)) {
        napa_dump_flag = TRUE;
      }
    }

    if (FALSE != napa_dump_flag) {
      napa_dump_states();
      napa_dump_flag = FALSE;
    }

    napa_abs_loop++;

  } while (!TERMINATE);

  /* (main loop completed)                  */
  napa_stage = 4;

  /* (RAM access report)                    */
  if (ISNOTSMALL(i_array_myram1.last)) {
    (void) fprintf(stderr,   "\nNAPA Run Time Information: loop[%lld] (array)\n",   (I_TYPE) i_array_myram1.last  );
    (void) fprintf(stderr,     " last access to uninitialized data in RAM <myram1[%lld]>\n", i_array_myram1.length);
    if (0 != fflush(NULL)) {
      (void) fprintf(stderr, "\nNAPA Run Time Error: (array)");
      (void) fprintf(stderr,    " flushing data from buffer I/O was not successfull\n");
      napa_exit(EXIT_FAILURE);
    }
  }

  /* (write file banner closing)            */
  napa_file_banner();

  /* (close I/O stream)                     */
  (void) IO_MANAGER(CLOSE, &napa_fp_0, "stdout", ".out", "output");

  (void) IO_MANAGER(CLOSE, &napa_fp_dump, "ex16.dmp", ".dmp", "dump");

  /* (end of simulation)                    */
  napa_stage = 5;
  napa_exit(EXIT_SUCCESS);

}


/* *** NAPA FUNCTIONS ********************************************************************************************************* */

void napa_control_init(void) {
  napa_wall_clock = clock();
  napa_seed = NAPA_SEED;
  napa_root = NAPA_ROOT;
  napa_rand = NAPA_RAND;
  (void) napa_init();
  (void) atexit(napa_end);
  (void) atexit(napa_close);
  return;
}

void napa_reset_variables(void) {
  i_var_RAM_SIZE = 32;
  (void) strcpy(s_var_ram_file, "data.ram");
  (void) randomize_array(i_var_RAM_SIZE,-5,5,s_var_ram_file);
  if (FALSE == (0<i_var_RAM_SIZE)) {
    (void) fprintf(stderr, "\nNAPA Run Time Error: (declare)\n");
    (void) fprintf(stderr,   " -> at line  31 of main netlist\n");
    (void) fprintf(stderr,   " -> at line   6 of \"/simulate/napados/net/counter/modcnt.net\"\n");
    (void) fprintf(stderr, "\n    Condition [ 0<RAM_SIZE ] is not valid!\n");
    napa_exit(EXIT_FAILURE);
  }
  init_cnt1__s2 = 5;
  if (FALSE == (0<8)) {
    (void) fprintf(stderr, "\nNAPA Run Time Error: (declare)\n");
    (void) fprintf(stderr,   " -> at line  32 of main netlist\n");
    (void) fprintf(stderr,   " -> at line   6 of \"/simulate/napados/net/counter/modcnt.net\"\n");
    (void) fprintf(stderr, "\n    Condition [ 0<8 ] is not valid!\n");
    napa_exit(EXIT_FAILURE);
  }
  init_cnt2__s2 = 5;
  i_var_ev1 = (I_TYPE)((10==LOOP_INDEX)||(100==LOOP_INDEX));
  (void) fprintf(stderr,   "\n");
  return;
}

void napa_reset_nodes(void) {
  i_node_a1 = DIGITAL_INI;
  i_node_a2 = DIGITAL_INI;
  i_node_rwb = DIGITAL_INI;
  i_node_b = DIGITAL_INI;
  i_node_r = DIGITAL_INI;
  i_node_d1 = DIGITAL_INI;
  i_node_d2 = DIGITAL_INI;
  i_node_One = DIGITAL_INI;
  i_node_One_dc = (I_TYPE) (1LL);
  i_node_cnt1__s1 = DIGITAL_INI;
  i_node_cnt2__s1 = DIGITAL_INI;
  i_node_cnt2__s2 = init_cnt2__s2;
  i_node_cnt1__s2 = init_cnt1__s2;
  return;
}

void napa_array_setup(IO_COMMAND command) {
  I_TYPE i, j, k;
  char  *p = (char*) NULL;
  char   buffer[4096] = {'\0'};
  char  *string = (char*) NULL;
  char  *tail   = (char*) NULL;
  switch(command) {
  case ALLOCATE:
    i_array_myram1.last   = 0.0L;
    i_array_myram1.length = i_var_RAM_SIZE;
    if (0L >= i_array_myram1.length) {
      (void) fprintf(stderr, "\nNAPA Run Time Error: (array)\n");
      (void) fprintf(stderr,   " Size of array <myram1[%lld]> must be strictly positive\n", i_array_myram1.length);
      napa_exit(EXIT_FAILURE);
    }
    i_array_myram1.flag = (int*)    calloc((size_t) i_array_myram1.length, sizeof(int   ));
    i_array_myram1.data = (I_TYPE*) calloc((size_t) i_array_myram1.length, sizeof(I_TYPE));
    if (((int*) NULL == i_array_myram1.flag) || ((I_TYPE*) NULL == i_array_myram1.data)) {
      (void) fprintf(stderr, "\nNAPA Run Time Error: (array)\n");
      (void) fprintf(stderr,   " Dynamic memory allocation error when");
      (void) fprintf(stderr,   " processing RAM array <myram1[%lld]>\n", i_array_myram1.length);
      napa_exit(EXIT_FAILURE);
    }
    i_array_myram1.rw   = 0LL;
    i_array_myram1.address = 0LL;
    for (i = 0L; i < i_array_myram1.length; i++) {
      i_array_myram1.flag[i] = FALSE;
      i_array_myram1.data[i] = DIGITAL_INI;
    }
    (void) IO_MANAGER(OPENREAD, &napa_fp_init_2, "data.rom", "", "array");
    i_array_myrom3.length = 8;
    if (0L >= i_array_myrom3.length) {
      (void) fprintf(stderr, "\nNAPA Run Time Error: (array)\n");
      (void) fprintf(stderr,   " Size of array <myrom3[%lld]> must be strictly positive\n", i_array_myrom3.length);
      napa_exit(EXIT_FAILURE);
    }
    i_array_myrom3.data = (I_TYPE*) calloc((size_t) i_array_myrom3.length, sizeof(I_TYPE));
    if ((I_TYPE*) NULL == i_array_myrom3.data) {
      (void) fprintf(stderr, "\nNAPA Run Time Error: (array)\n");
      (void) fprintf(stderr,   " Dynamic memory allocation error when");
      (void) fprintf(stderr,   " processing ROM array <myrom3[%lld]>\n", i_array_myrom3.length);
      napa_exit(EXIT_FAILURE);
    }
    i_array_myrom3.address = 0LL;
    i = 0L;
    k = 1L;
    p = fgets(buffer, 4095, napa_fp_init_2);
    while (((char*) NULL != p) && (i < i_array_myrom3.length)) {
      string = buffer;
      if ('#' != *string) {
        while ((int) isspace(*string)) {
          string++;
        }
        if ('\0' == *string) {
          (void) fprintf(stderr, "\nNAPA Run Time Error (myrom3):\n\n");
          (void) fprintf(stderr,   " -> array file <\"data.rom\">, at line %lld\n", k);
          (void) fprintf(stderr,   "    line is empty\n");
          napa_exit(EXIT_FAILURE);
        }
        j = strtoll(string, &tail, 0);
        string = tail;
        while ((int) isspace(*string)) {
          string++;
        }
        if ('\0' == *string) {
          (void) fprintf(stderr, "\nNAPA Run Time Error (myrom3):\n\n");
          (void) fprintf(stderr,   " -> array file <\"data.rom\">, at line %lld\n", k);
          (void) fprintf(stderr,   "    data is missing\n");
          napa_exit(EXIT_FAILURE);
        }
        if (2 > sscanf(buffer, "%lli %lli", &j, &(i_array_myrom3.data[i]))) {
          break;
        }
        if (i != j) {
          (void) fprintf(stderr, "\nNAPA Run Time Error (myrom3):\n\n");
          (void) fprintf(stderr,   " -> array file <\"data.rom\">, at line %lld\n", k);
          (void) fprintf(stderr,   "    data is not properly numbered\n");
          napa_exit(EXIT_FAILURE);
        }
        i++;
      }
      k++;
      p = fgets(buffer, 4095, napa_fp_init_2);
    }
    if (i_array_myrom3.length != i) {
      (void) fprintf(stderr, "\nNAPA Run Time Error (myrom3):\n\n");
      (void) fprintf(stderr,   " -> array file <\"myrom3\"> contains %lld numbers,\n", i);
      (void) fprintf(stderr,   "    but declaration of <myrom3[]> asked for");
      (void) fprintf(stderr,   " %lld coefficients...\n", i_array_myrom3.length);
      napa_exit(EXIT_FAILURE);
    }
    (void) IO_MANAGER(CLOSE,    &napa_fp_init_2, "data.rom", "", "array");
    break;
  case FREE:
    free(i_array_myram1.flag);
    i_array_myram1.flag = (int*) NULL;
    free(i_array_myram1.data);
    i_array_myram1.data = (I_TYPE*) NULL;
    free(i_array_myrom3.data);
    i_array_myrom3.data = (I_TYPE*) NULL;
    break;
  case RESET:
    (void) fprintf(stderr,   "\nNAPA Run Time Error (myrom3):\n\n");
    (void) fprintf(stderr,     " no reset possible for digital arrays\n");
    napa_exit(EXIT_FAILURE);
  case DEBUG:
    (void) fprintf(stderr,   "\nNAPA Debug Information: (digital array)  <myram1>)\n");
    (void) fprintf(stderr,     "  simulation loop # %lld\n", LOOP_INDEX);
    for (i = 0L; i < i_array_myram1.length; i++) {
      if (FALSE == i_array_myram1.flag[i]) {;
        (void) fprintf(stderr, "  myram1[%3lld] =   ?\n", i);
      } else {
        (void) fprintf(stderr, "  myram1[%3lld] =  % lld\n", i, i_array_myram1.data[i]);
      }
    }
    (void) fprintf(stderr,   "\nNAPA Debug Information: (digital array)  <myrom3>)\n");
    (void) fprintf(stderr,     "  simulation loop # %lld\n", LOOP_INDEX);
    for (i = 0L; i < i_array_myrom3.length; i++) {
      (void) fprintf(stderr,   "  myrom3[%3lld] =  % lld\n", i, i_array_myrom3.data[i]);
    }
    (void) fprintf(stderr,   "\n");
    break;
  default:
    break;
  }
  return;
}

void napa_dump_states(void) {
  long i;
  static long n = 0L;
#if defined(DEBUG_MODE_DUMP)
  (void) fprintf(stderr,           "NAPA Debug Information: (        dump)");
  (void) fprintf(stderr,           " <- %Lg\n", napa_abs_loop);
#endif
  if (0 != fflush(NULL)) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error: (dump)");
    (void) fprintf(stderr,         " flushing data from buffer I/O was not successfull\n");
    napa_exit(EXIT_FAILURE);
  }
  (void) fprintf(napa_fp_dump,   "\n/* *** %118s *** */\n",   " ");
  (void) fprintf(napa_fp_dump,     "/* *** %118s *** */\n\n", " ");
  if (0L == n) {
    (void) fprintf(napa_fp_dump,   "#if ((!defined DUMP) || (%ld == DUMP))\n", n);
  } else {
    (void) fprintf(napa_fp_dump,   "#if (%ld == DUMP)\n", n);
  } 
  (void) fprintf(napa_fp_dump,     "# define DUMP_FLAG\n\n");
  (void) fprintf(napa_fp_dump,     "  (void) fprintf(stderr, \" with %ld == DUMP\");\n\n", n);
  (void) fprintf(napa_fp_dump,     "# if !defined(NO_GLOBAL)\n");
  (void) fprintf(napa_fp_dump,     "  napa_abs_time    = % .15LeL;\n", napa_abs_time);
  (void) fprintf(napa_fp_dump,     "  napa_ref_time    = % .15LeL;\n", napa_abs_time);
  (void) fprintf(napa_fp_dump,     "  napa_abs_loop    = % .15LeL;\n", napa_abs_loop);
  (void) fprintf(napa_fp_dump,     "# endif\n\n");
  (void) fprintf(napa_fp_dump,     "# if !defined(NO_ARRAY)\n");
  (void) fprintf(napa_fp_dump,     "  i_array_myram1.last      = % .1lld;\n", (I_TYPE) i_array_myram1.last);
  (void) fprintf(napa_fp_dump,     "  i_array_myram1.length    = % lldLL;\n",  i_array_myram1.length);
  (void) fprintf(napa_fp_dump,     "  i_array_myram1.address   = % lldLL;\n",  i_array_myram1.address);
  (void) fprintf(napa_fp_dump,     "  i_array_myram1.rw        = % lldLL;\n",   i_array_myram1.rw);
  for (i = 0L; i < ((long) i_array_myram1.length); i++) {
    if (1 == i_array_myram1.flag[i]) {
      (void) fprintf(napa_fp_dump, "  i_array_myram1.flag[%3ld] =   TRUE;", i);
    } else {
      (void) fprintf(napa_fp_dump, "  i_array_myram1.flag[%3ld] =  FALSE;", i);
    }
    (void) fprintf(napa_fp_dump,   "  i_array_myram1.data[%3ld] = % lldLL;\n", i, i_array_myram1.data[i]);
  }
  (void) fprintf(napa_fp_dump,     "  i_array_myrom3.length    = % lldLL;\n",  i_array_myrom3.length);
  (void) fprintf(napa_fp_dump,     "  i_array_myrom3.address   = % lldLL;\n",  i_array_myrom3.address);
  for (i = 0L; i < ((long) i_array_myrom3.length); i++) {
    (void) fprintf(napa_fp_dump,   "  i_array_myrom3.data[%3ld] = % lldLL;\n", i, i_array_myrom3.data[i]);
  }
  (void) fprintf(napa_fp_dump,     "# endif\n\n");
  (void) fprintf(napa_fp_dump,     "# if !defined(NO_VAR)\n");
  (void) fprintf(napa_fp_dump,     "  i_var_RAM_SIZE = % lldLL;\n", i_var_RAM_SIZE);
  (void) fprintf(napa_fp_dump,     "  (void) strcpy(s_var_ram_file, \"%s\");\n", s_var_ram_file);
  (void) fprintf(napa_fp_dump,     "  i_var_ev1 = % lldLL;\n", i_var_ev1);
  (void) fprintf(napa_fp_dump,     "# endif\n\n");
  (void) fprintf(napa_fp_dump,     "# if !defined(NO_NODE)\n");
  (void) fprintf(napa_fp_dump,     "  i_node_a1 = % lldLL;\n", i_node_a1);
  (void) fprintf(napa_fp_dump,     "  i_node_a2 = % lldLL;\n", i_node_a2);
  (void) fprintf(napa_fp_dump,     "  i_node_rwb = % lldLL;\n", i_node_rwb);
  (void) fprintf(napa_fp_dump,     "  i_node_b = % lldLL;\n", i_node_b);
  (void) fprintf(napa_fp_dump,     "  i_node_r = % lldLL;\n", i_node_r);
  (void) fprintf(napa_fp_dump,     "  i_node_d1 = % lldLL;\n", i_node_d1);
  (void) fprintf(napa_fp_dump,     "  i_node_d2 = % lldLL;\n", i_node_d2);
  (void) fprintf(napa_fp_dump,     "  i_node_One = % lldLL;\n", i_node_One);
  (void) fprintf(napa_fp_dump,     "  i_node_One_dc = % lldLL;\n", i_node_One_dc);
  (void) fprintf(napa_fp_dump,     "  i_node_cnt1__s1 = % lldLL;\n", i_node_cnt1__s1);
  (void) fprintf(napa_fp_dump,     "  i_node_cnt2__s1 = % lldLL;\n", i_node_cnt2__s1);
  (void) fprintf(napa_fp_dump,     "  i_node_cnt2__s2 = % lldLL;\n", i_node_cnt2__s2);
  (void) fprintf(napa_fp_dump,     "  i_node_cnt1__s2 = % lldLL;\n", i_node_cnt1__s2);
  (void) fprintf(napa_fp_dump,     "# endif\n\n");
  (void) fprintf(napa_fp_dump,     "#endif\n\n");
  n++;
  return;
}

void napa_file_banner(void) {
#if defined(STRICTLY_NO_BANNER)
  return;
#else
  if ((1 == napa_stage) || (2 == napa_stage)) {
# if !defined(NO_BANNER)
    (void) fprintf(napa_fp_0,      "#  %s\n",                            TITLE);
    (void) fprintf(napa_fp_0,      "# (time domain output  )\n");
    (void) fprintf(napa_fp_0,      "# (compiler version    ) NAPA %s\n", NAPA_VERSION);
    (void) fprintf(napa_fp_0,      "# (source file         ) %s\n",      SOURCE);
    (void) fprintf(napa_fp_0,      "# (random seed         ) %lld\n",    RANDOM_SEED);
    (void) fprintf(napa_fp_0,      "# (output sampling rate) 1.00000 MHz\n");
#  if !defined(NO_TIME_OUTPUT)
    (void) fprintf(napa_fp_0,      "# (number of columns   ) 7\n#\n#\n#\n#\n#\n#\n");
#  else
    (void) fprintf(napa_fp_0,      "# (number of columns   ) 6\n#\n#\n#\n#\n#\n#\n");
#  endif
    (void) fprintf(napa_fp_0,      "# %s\n", CREATED);
# endif
  }
  if ((1 == napa_stage) || (2 == napa_stage) || (4 == napa_stage)) {
# if !defined(NO_TIME_OUTPUT)
    (void) fprintf(napa_fp_0,      "# absolute_time(s)     ");
# else
    (void) fprintf(napa_fp_0,      "#");
# endif
    (void) fprintf(napa_fp_0,      "          a1");
    (void) fprintf(napa_fp_0,      "          a2");
    (void) fprintf(napa_fp_0,      "         rwb");
    (void) fprintf(napa_fp_0,      "           r");
    (void) fprintf(napa_fp_0,      "          d1");
    (void) fprintf(napa_fp_0,      "          d2\n");
  }
  if  (4 == napa_stage) {
# if !defined(NO_BANNER)
    (void) fprintf(napa_fp_0,      "#\n");
    (void) fprintf(napa_fp_0,      "# (end of output file  )\n");
# endif
  }
  if ((1 == napa_stage) || (2 == napa_stage)) {
    (void) fprintf(napa_fp_dump, "\n/* ***  THIS DUMP FILE CREATED BY NAPA X3.05e [Win64] AT RUN TIME,");
    (void) fprintf(napa_fp_dump,   " IS BUILT TO BE LOADED BY THE INSTRUCTION 'load'. %9s *** */\n", " ");
    (void) fprintf(napa_fp_dump,   "/* ***  Mon Apr 30 09:45:02 2018 %92s *** */\n\n", " ");
    (void) fprintf(napa_fp_dump,   "/* ***  SOURCE: %-109s *** */\n\n", SOURCE);
    (void) fprintf(napa_fp_dump,   "/* *** %118s *** */\n", " ");
    (void) fprintf(napa_fp_dump,   "/* ***  %s", "RAM and ROM");
    (void) fprintf(napa_fp_dump,   "  %*s *** */\n", 104, " ");
    (void) fprintf(napa_fp_dump,   "/* *** %118s *** */\n\n\n", " ");
    (void) fprintf(napa_fp_dump,   "/* *** %118s *** */\n",     " ");
    (void) fprintf(napa_fp_dump,   "/* *** %118s *** */\n\n",   " ");
    (void) fprintf(napa_fp_dump,   "#undef   DUMP_FLAG\n\n");
    (void) fprintf(napa_fp_dump,   "#define  DUMP_IS_REGISTERED\n\n");
    (void) fprintf(napa_fp_dump,   "#define  NO_ARRAY_IS_REGISTERED\n");
    (void) fprintf(napa_fp_dump,   "#define  NO_GLOBAL_IS_REGISTERED\n");
    (void) fprintf(napa_fp_dump,   "#define  NO_NODE_IS_REGISTERED\n");
    (void) fprintf(napa_fp_dump,   "#define  NO_TOOL_IS_REGISTERED\n");
    (void) fprintf(napa_fp_dump,   "#define  NO_VAR_IS_REGISTERED\n\n");
  }
  if  (4 == napa_stage) {
    (void) fprintf(napa_fp_dump, "\n/* *** %118s *** */\n",   " ");
    (void) fprintf(napa_fp_dump,   "/* *** %118s *** */\n\n", " ");
    (void) fprintf(napa_fp_dump,   "# if !defined(DUMP_FLAG)\n");
    (void) fprintf(napa_fp_dump,   "  (void) fprintf(stderr, \" has no effect.\\n\\n\");\n");
    (void) fprintf(napa_fp_dump,   "#endif\n\n");
    (void) fprintf(napa_fp_dump, "\n/* *** %118s *** */\n",   " ");
    (void) fprintf(napa_fp_dump,   "/* *** %118s *** */\n\n", " ");
    (void) fprintf(napa_fp_dump,   "/* *** End of dump file %101s *** */\n", " ");
  }
  if ((3 == napa_stage) && (!TERMINATE)) {
    (void) fprintf(napa_fp_0,      "%s", SEPARATOR);
  }
  return;
#endif
}


/* *** STREAMLINED I/O RESOURCES MANAGER *** [Case Insensitive OS] ************************************************************ */
/* *** OPERATIONS:     OPENREAD, OPENWRITE, CLOSE, FREE                                                                         */

IO_COMMAND napa_IO_manager(IO_COMMAND command, FILE **fp, char *filename, char *suffix, char *tag) {
  static long  id = 0L;
  const size_t sz = 255;
  char user[256]  = {'\0'};
  char nam1[256]  = {'\0'};
  char nam2[256]  = {'\0'};
  char str[2]     = " ";
  long i, j, index, length;
  int  iflag, oflag;
  iflag = FALSE;
  oflag = FALSE;
  if (0 != fflush(NULL)) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error: (I/O manager for %s)\n", tag);
    (void) fprintf(stderr,         " flushing data from buffer I/O was not successfull\n");
    napa_exit(EXIT_FAILURE);
  }
  if (FREE != command) {
    length = (long) strlen(filename);
    if (0L == length) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error: (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream name is missing\n");
      napa_exit(EXIT_FAILURE);
    }
    length = 1L + MIN(length + ((long) strlen(suffix)), (long) sz);
    (void) snprintf(user, (size_t) length, "%s", filename);
    if ((char*) NULL == strstr(user, ".")) {
      if ((0 != strncmp(user, "stdin", sz)) && (0 != strncmp(user, "stdout", sz)) && (0 != strncmp(user, "stderr", sz))) {
        (void) strcat(user, suffix);
      }
    }
    for (i = 0L; i < length; i++) {
      nam1[i] = (char) tolower((int) user[i]);
    }
    index = -1L;
    for (i = 0L; i < napa_IO_count; i++) {
      for (j = 0L; j <= ((long) strlen(napa_IO_record[i].user)); j++) {
        nam2[j] = (char) tolower((int) ((napa_IO_record[i].user)[j]));
      }
      if (0 == strncmp(nam1, nam2, sz)) {
        index = i;
        if (0 != strncmp(user, napa_IO_record[index].user, sz)) {
          (void) fprintf(stderr, "\nNAPA Run Time Error: (I/O manager for %s)\n\n", tag);
          (void) fprintf(stderr,   " Collision between I/O streams in a case-insensitive context:");
          (void) fprintf(stderr,   " <%s> and <%s>\n\n", user, napa_IO_record[index].user);
          napa_exit(EXIT_FAILURE);
        }
        break;
      }
    }
  }
  switch (command) {
  case OPENWRITE:
    if (0 == strncmp(user, "stdin", sz)) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error: (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Standard Input <%s> cannot be opened for write\n", user);
      napa_exit(EXIT_FAILURE);
    }
    str[0] = 'w';
    oflag = TRUE;
    break;
  case OPENREAD:
    if ((0 == strncmp(user, "stdout", sz)) || (0 == strncmp(user, "stderr", sz))) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error: (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Standard I/O stream <%s> cannot be opened for read\n", user);
      napa_exit(EXIT_FAILURE);
    }
    str[0] = 'r';
    iflag = TRUE;
    break;
  case CLOSE:
    if (-1L == index) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error: (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream <%s> cannot be closed as it has not been registered\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ((FILE*) NULL == napa_IO_record[index].f_ptr) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error: (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream <%s> is already closed\n", user);
      napa_exit(EXIT_FAILURE);
    }
    if ((0 != strncmp(user, "stdin", sz)) && (0 != strncmp(user, "stdout", sz)) && (0 != strncmp(user, "stderr", sz))) {
      if (0 != fclose(napa_IO_record[index].f_ptr)) {
        (void) fprintf(stderr,   "\nNAPA Run Time Error: (I/O manager for %s)\n", tag);
        (void) fprintf(stderr,     " Unable to close I/O stream <%s>\n", user);
        napa_exit(EXIT_FAILURE);
      }
    }
    napa_IO_record[index].f_ptr = (FILE*) NULL;
    napa_IO_record[index].mode  = command;
#if defined(DEBUG_MODE_IO)
    (void) fprintf(stderr,         "NAPA Debug Information:   (Close  I/O stream )");
    (void) fprintf(stderr,         " %18s for %-18s <- % .0Lf\n", user, tag, napa_abs_loop);
#endif
    *fp = (FILE*) NULL;
    return command;
  case FREE:
    if (0L >= napa_IO_count) {
      (void) fprintf(stderr,       "NAPA Run Time Warning:    (Purge  I/O stream )");
      (void) fprintf(stderr,       " there is currently no I/O record to free\n");
      return command;
    }
    j = 0L;
    for (i = 0L; i < napa_IO_count; i++) {
      if (UNKNOWN == napa_IO_record[i].mode) {
        continue;
      }
      if (CLOSE == napa_IO_record[i].mode) {
#if defined(DEBUG_MODE_IO) && defined(VERBOSE)
        (void) fprintf(stderr,     "NAPA Debug Information:   (Purge  I/O stream )");
        (void) fprintf(stderr,     " I/O record #%-2ld is freed\n", napa_IO_record[i].id);
#endif
        free(napa_IO_record[i].user);
        napa_IO_record[i].user  = (char*) NULL;
      } else {
        (void) strcpy(napa_IO_record[j].user, napa_IO_record[i].user);
        napa_IO_record[j].f_ptr = napa_IO_record[i].f_ptr;
        napa_IO_record[j].id    = napa_IO_record[i].id;
        napa_IO_record[j].mode  = napa_IO_record[i].mode;
        napa_IO_record[j].iflag = napa_IO_record[i].iflag;
        napa_IO_record[j].oflag = napa_IO_record[i].oflag;
        j++;
      }
    }
    napa_IO_count = j;
#if defined(DEBUG_MODE_IO) && defined(VERBOSE)
    if (0L < napa_IO_count) {
      (void) fprintf(stderr,       "NAPA Debug Information:   (Purge  I/O stream )");
      (void) fprintf(stderr,       " %ld I/O records still allocated\n", napa_IO_count);
    }
#endif
    return command;
  case OPENREAD_BINARY:
  case REWIND:
  case OPENAPPEND:
  case OPENAPPEND_BINARY:
  case OPENWRITE_BINARY:
  case REWRITE:
  case QUERY:
  case DEBUG:
    (void) fprintf(stderr,       "\nNAPA Run Time Error: (I/O manager for %s)\n", tag);
    (void) fprintf(stderr,         " I/O stream management command <%d> not implemented in this streamlined manager\n", command);
    napa_exit(EXIT_FAILURE);
  default:
    (void) fprintf(stderr,       "\nNAPA Run Time Error: (I/O manager for %s)\n", tag);
    (void) fprintf(stderr,         " Unknown I/O stream management command <%d>\n", command);
    napa_exit(EXIT_FAILURE);
  }
  if (-1L == index) {
    napa_IO_record[napa_IO_count].user = (char*) calloc((size_t) (1L+length), sizeof(char));
    if ((char*) NULL == napa_IO_record[napa_IO_count].user) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error: (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Dynamic memory allocation error while recording I/O stream <%s>\n", user);
      napa_exit(EXIT_FAILURE);
    }
  } else {
    if ((FILE*) NULL != napa_IO_record[index].f_ptr) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error: (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " I/O stream <%s> cannot be opened twice\n", user);
      napa_exit(EXIT_FAILURE);
    }
  }
  if        (0 == strncmp(user, "stdin",  sz)) {
    *fp = stdin;
  } else if (0 == strncmp(user, "stdout", sz)) {
    *fp = stdout;
  } else if (0 == strncmp(user, "stderr", sz)) {
    *fp = stderr;
  } else {
    *fp = fopen(user, str);
    if ((FILE*) NULL == *fp) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error: (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Unable to open I/O file <%s>\n", user);
      napa_exit(EXIT_FAILURE);
    }
  }
  if (-1L == index) {
    (void) strcpy(napa_IO_record[napa_IO_count].user, user);
    napa_IO_record[napa_IO_count].f_ptr = *fp;
    napa_IO_record[napa_IO_count].id    = id;
    napa_IO_record[napa_IO_count].mode  = command;
    napa_IO_record[napa_IO_count].iflag = iflag || napa_IO_record[napa_IO_count].iflag;
    napa_IO_record[napa_IO_count].oflag = oflag || napa_IO_record[napa_IO_count].oflag;
#if defined(DEBUG_MODE_IO) && defined(VERBOSE)
    (void) fprintf(stderr,         "NAPA Debug Information:   (Create I/O stream )");
    (void) fprintf(stderr,         " <record[%4ld]>\n", id);
#endif
    id++;
    napa_IO_count++;
    if (127L <= napa_IO_count) {
      (void) fprintf(stderr,     "\nNAPA Run Time Error: (I/O manager for %s)\n", tag);
      (void) fprintf(stderr,       " Internal arrays overflow (max = 127 I/O) while registering I/O stream <%s>\n", user);
      napa_exit(EXIT_FAILURE);
    }
  } else {
    napa_IO_record[index].f_ptr = *fp;
    napa_IO_record[index].mode  = command;
    napa_IO_record[index].iflag = iflag || napa_IO_record[index].iflag;
    napa_IO_record[index].oflag = oflag || napa_IO_record[index].oflag;
  }
#if defined(DEBUG_MODE_IO)
  (void) fprintf(stderr,           "NAPA Debug Information:   (Open   I/O stream )");
  (void) fprintf(stderr,           " %18s for %-18s <- % .0Lf\n", user, tag, napa_abs_loop);
#endif
  return command;
}


/* *** SEED RANDOMIZER (MATSUMOTO & NISHIMURA IMPROVED LCG) ******************************************************************* */

#if !defined(EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR)

I_TYPE napa_default_root(I_TYPE seed) {
  unsigned long ulrnd;
  static unsigned long j = 1UL;
  ulrnd = ((unsigned long) seed) & 0XFFFFFFFFUL;
  ulrnd = (1812433253UL * (ulrnd^(ulrnd >> 30))) + j;
  j++;
  return (I_TYPE) (ulrnd & 0XFFFFFFFFUL);
}

#endif


/* *** PSEUDO-RANDOM NUMBER GENERATOR (MERSENNE TWISTER MT19937-64) *********************************************************** */
/* *** Source: Takuji Nishimura and Makoto Matsumoto, version 2004/9/29                                                    **** */
/* *** Modified to fit NAPA X3.05e                                                                                         **** */

#if !defined(EXTERNAL_PSEUDO_RANDOM_NUMBER_GENERATOR)

unsigned long long napa_random_mta[312];
int                napa_random_mti = 0;

I_TYPE napa_default_seed(I_TYPE seed) {
  time_t t;
  if (0LL == seed) {
    (void) time(&t);
    seed = ((I_TYPE) t) / 2LL;
  } else {
    seed = (0LL < seed) ? seed : -seed;
  }
  napa_random_mta[0] = (unsigned long long) napa_root(seed);
  for (napa_random_mti = 1; napa_random_mti < 312; napa_random_mti++) {
    napa_random_mta[napa_random_mti]  = napa_random_mta[napa_random_mti-1];
    napa_random_mta[napa_random_mti] ^= napa_random_mta[napa_random_mti-1] >> 62;
    napa_random_mta[napa_random_mti] *= 6364136223846793005ULL;
    napa_random_mta[napa_random_mti] += napa_random_mti;
  }
  return seed;
}

I_TYPE napa_default_rand(void) {
  int i;
  unsigned long long x;
  static unsigned long long mag01[2] = {0ULL, 0XB5026F5AA96619E9ULL};
  if (312 <= napa_random_mti) {
    for (i = 0; i < 156; i++) {
      x = (napa_random_mta[  i] & 0XFFFFFFFF80000000ULL) | (napa_random_mta[i+1] & 0X7FFFFFFFULL);
      napa_random_mta[i] = napa_random_mta[i+156] ^ (x>>1) ^ mag01[(int) (x&1ULL)];
    }
    for (i = 156; i < 311; i++) {
      x = (napa_random_mta[  i] & 0XFFFFFFFF80000000ULL) | (napa_random_mta[i+1] & 0X7FFFFFFFULL);
      napa_random_mta[i] = napa_random_mta[i-156] ^ (x>>1) ^ mag01[(int) (x&1ULL)];
    }
    x =   (napa_random_mta[311] & 0XFFFFFFFF80000000ULL) | (napa_random_mta[  0] & 0X7FFFFFFFULL);
    napa_random_mta[311] = napa_random_mta[  155] ^ (x>>1) ^ mag01[(int) (x&1ULL)];
    napa_random_mti = 0;
  }
  x  = napa_random_mta[napa_random_mti++];
  x ^= (x >> 29) & 0X5555555555555555ULL;
  x ^= (x << 17) & 0X71D67FFFEDA60000ULL;
  x ^= (x << 37) & 0XFFF7EEE000000000ULL;
  x ^= (x >> 43);
  return (I_TYPE) (x >> 1);
}

#endif


/* *** TIMER FUNCTION ********************************************************************************************************* */

void napa_timer(long cnt) {
  time_t time_start;
  time_t time_stop;
  if (0L < cnt) {
    (void) time(&time_start);
    do {
      (void) time(&time_stop);
    } while (((long) (time_stop - time_start)) <= cnt);
  }
  return;
}


/* *** EXIT FUNCTIONS ********************************************************************************************************* */

void napa_exit(long status) {
  if (EXIT_FAILURE == status) {
    napa_error_flag = TRUE;
    (void) fprintf(stderr,     "\n\n ****  ERROR detected");
    switch (napa_stage) {
      case 0: (void) fprintf(stderr, " before the initialization of the simulation.\n\n"                ); break;
      case 1: (void) fprintf(stderr, " during the 1st part of the initialization of the simulation.\n\n"); break;
      case 2: (void) fprintf(stderr, " during the 2nd part of the initialization of the simulation.\n\n"); break;
      case 3: (void) fprintf(stderr, " at loop %.0Lf during the simulation.\n\n",          napa_abs_loop); break;
      case 4: (void) fprintf(stderr, " at loop %.0Lf when simulation is closing.\n\n",     napa_abs_loop); break;
      case 5: (void) fprintf(stderr, " during the execution of the NAPA exit code.\n\n"                 ); break;
    }
  }
  if (0 != fflush(NULL)) {
    (void) fprintf(stderr,       "\nNAPA Run Time Error: (exit)");
    (void) fprintf(stderr,         " flushing data from buffer I/O was not successfull\n\n");
    napa_exit(EXIT_FAILURE);
  }
  exit(status);
}

void napa_end(void) {
  napa_array_setup(FREE);
  if (FALSE == napa_error_flag) {
    (void) IO_MANAGER(FREE, NULL, NULL, NULL, "end");
    (void) fprintf(stderr,     "\n\n ****  Normal Termination %25s ****\n\n", " ");
  }
  return;
}


/* *** FILE BUILT IN 103  ms (WALL CLOCK) FOR Yves Leduc ********************************************************************** */

