#
# **** GNUPLOT CONTROL FILE ****   for data contained in file <ex20.out>
#
#  Example of PWL functions 
# (time domain output  ) 
# (compiler version    ) NAPA V3.05d for Win64 
# (source file         ) ex20.tmp 
# (random seed         ) 761345899 
# (output sampling rate) 50.0000 kHz 
# (number of columns   ) 8 
# 
# 
# 
# 
# 
# 
# Mon Apr 02 19:56:39 2018 by Yves Leduc 
#
print("\n")
print(" *****  About to plot data from file \"ex20.out\"  *****\n")
print("\n")
#
#
myfile = "ex20.out"
#
pause 1
#
# Set-up for a STANDARD 2D plot
#
short = "  Example of PWL functions \n Yves Leduc "
long  = "  Example of PWL functions \n Mon Apr 02 19:56:39 2018 by Yves Leduc "
#
# Select here your title (short or long):
set title long
#
set grid
set datafile missing "?"
if (!exists("MY_FLAG_PLOT_2D")) {
  set style data lines
  MY_FLAG_PLOT_2D = 1
}
set xlabel "absolute time(s)"
set ylabel ""
set zlabel ""
set format "%.1s%c"
set macro
#
# Use 'dy = xxx'.. to space the data on the vertical axis
if (!exists("dy")) { dy = 0 }
if (0 != dy) {
  set format y " "
} else {
  set format y
}
# Use 'w0 = nnn' to set the default line width, and/or 'w1 = nnn ...' to modify individual line widths 
#
if (!exists("w0")) { w0 =  0 }
if (!exists("w1")) { w1 = w0 }
if (!exists("w2")) { w2 = w0 }
if (!exists("w3")) { w3 = w0 }
if (!exists("w4")) { w4 = w0 }
if (!exists("w5")) { w5 = w0 }
if (!exists("w6")) { w6 = w0 }
if (!exists("w7")) { w7 = w0 }
#
MYPLOT1  = "myfile  u  1: 2            lw w1  t 'a'"
MYPLOT2  = "myfile  u  1:($3 +( 1*dy)) lw w2  t 'b'"
MYPLOT3  = "myfile  u  1:($4 +( 2*dy)) lw w3  t 'c'"
MYPLOT4  = "myfile  u  1:($5 +( 3*dy)) lw w4  t 'd'"
MYPLOT5  = "myfile  u  1:($6 +( 4*dy)) lw w5  t 'e'"
MYPLOT6  = "myfile  u  1:($7 +( 5*dy)) lw w6  t 'f'"
MYPLOT7  = "myfile  u  1:($8 +( 6*dy)) lw w7  t 'g'"
#
#
# Tips: use macro @MYPLOTn to plot more sophisticated graphs, like
#   ->  plot @MYPLOT1 smooth bezier
#   ->  plot @MYPLOT1 smooth bezier, @MYPLOT7  w p
#   ->  ...
#
#
plot  @MYPLOT1, @MYPLOT2, @MYPLOT3, @MYPLOT4, @MYPLOT5, @MYPLOT6, @MYPLOT7
#
#
# end
