@echo off

color F0

rem  Initialize variables if not already done
call \Simulate\Napados\Dos\UserInit.bat

if .==.%OWNER%                     call \Simulate\MyInit.bat


if exist *.bak  del *.bak
if exist *.out  del *.out
if exist *.exe  del *.exe
if exist *.tmp  del *.tmp
if exist *.exp  del *.exp
if exist *.lst  del *.lst
if exist *.gen  del *.gen
if exist *.dmp  del *.dmp
if exist *.log  del *.log
if exist *.c    del *.c
if exist *.prof del *.prof

if exist Output\*.out  del  Output\*.out

rem  ====================================

setlocal ENABLEEXTENSIONS

set start_time=%time%
echo.
echo.
echo  ****
echo  ****  Beginning at: %start_time%
echo  ****  Running Timed Batch File
echo.

echo ===============================================================================
echo.
echo This batch file will process:
echo.

for %%f in (*.nap) do (
echo [%%~nf.nap]
)

echo.
for %%f in (*.nap) do (
call _run.bat %%~nf
)

rem  ====================================

set stop_time=%time%
echo ===============================================================================
echo.
echo.
echo  ****
echo  ****  Timed Batch File Completed
echo  ****
echo  ****  Start time: %start_time%
echo  ****   Stop time: %stop_time%

set TEMPRESULT=%start_time:~0,2%
call:FN_REMOVELEADINGZEROS
set start_hour=%TEMPRESULT%
@rem
set TEMPRESULT=%start_time:~3,2%
call:FN_REMOVELEADINGZEROS
set start_min=%TEMPRESULT%
@rem
set TEMPRESULT=%start_time:~6,2%
call:FN_REMOVELEADINGZEROS
set start_sec=%TEMPRESULT%
@rem
set TEMPRESULT=%start_time:~9,2%
call:FN_REMOVELEADINGZEROS
set start_hundredths=%TEMPRESULT%

set TEMPRESULT=%stop_time:~0,2%
call:FN_REMOVELEADINGZEROS
set stop_hour=%TEMPRESULT%
@rem
set TEMPRESULT=%stop_time:~3,2%
call:FN_REMOVELEADINGZEROS
set stop_min=%TEMPRESULT%
@rem
set TEMPRESULT=%stop_time:~6,2%
call:FN_REMOVELEADINGZEROS
set stop_sec=%TEMPRESULT%
@rem
set TEMPRESULT=%stop_time:~9,2%
call:FN_REMOVELEADINGZEROS
set stop_hundredths=%TEMPRESULT%

set /A start_total=(((((%start_hour%*60)+%start_min%)*60)+%start_sec%)*100)+%start_hundredths%
set /A stop_total=(((((%stop_hour%*60)+%stop_min%)*60)+%stop_sec%)*100)+%stop_hundredths%

set /A total_time=%stop_total% - %start_total%

set /A total_hundredths=%total_time% %% 100
set total_hundredths=00%total_hundredths%
set total_hundredths=%total_hundredths:~-2%
set /A total_time=%total_time% / 100

set /A total_sec="%total_time% %% 60"
set total_sec=00%total_sec%
set total_sec=%total_sec:~-2%
set /A total_time=%total_time% / 60

set /A total_min="%total_time% %% 60"
set total_min=00%total_min%
set total_min=%total_min:~-2%
set /A total_time=%total_time% / 60

set /A total_hour="%total_time% %% 60"
@rem Handle if it wrapped around over midnight
if "%total_hour:~0,1%"=="-" set /A total_hour=%total_hour% + 24

echo  ****
echo  ****  Total time:  %total_hour%:%total_min%:%total_sec%.%total_hundredths%
echo  ****

@rem --------------------------------------------
@rem Exit the BAT Program
endlocal
goto END

@rem --------------------------------------------
@rem FN_REMOVELEADINGZEROS function
@rem  Used to remove leading zeros from Decimal
@rem  numbers so they are not treated as Octal.
:FN_REMOVELEADINGZEROS
if "%TEMPRESULT%"=="0" goto END
if "%TEMPRESULT:~0,1%" NEQ "0" goto END
set TEMPRESULT=%TEMPRESULT:~1%
goto FN_REMOVELEADINGZEROS

@rem --------------------------------------------
@rem BAT PROGRAM / FUNCTION FILE EXIT

:END

echo.
echo.
echo ===============================================================================
echo ===============================================================================
echo ===============================================================================
echo.
echo.
set /P ="Press Enter to continue . . . "

cls
echo.
